/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.NameBind;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbType;
import java.sql.SQLException;

public class Parameter
extends Column {
    public static final byte TYPE_FLAG_UNKNOWN = 0;
    public static final byte TYPE_FLAG_EXACT = 1;
    public static final byte TYPE_FLAG_RECOMMEND = 2;
    public byte typeFlag = 0;
    public static final byte IO_TYPE_IN = 0;
    public static final byte IO_TYPE_OUT = 1;
    public static final byte IO_TYPE_INOUT = 2;
    public byte ioType = 0;
    public int outJType = Integer.MIN_VALUE;
    public int outScale = -1;
    public String outObjectName;
    public DmdbStatement cursorStmt;
    public boolean hasDefault;

    public void resetType(int n2) {
        this.type = n2;
        this.scale = DmdbType.isLocalTimeZone(n2, this.scale) ? this.scale : 0;
        switch (n2) {
            case 3: 
            case 13: {
                this.prec = 1;
                break;
            }
            case 5: {
                this.prec = 1;
                break;
            }
            case 6: {
                this.prec = 2;
                break;
            }
            case 7: {
                this.prec = 4;
                break;
            }
            case 8: {
                this.prec = 8;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.prec = 8188;
                break;
            }
            case 19: {
                this.prec = Integer.MAX_VALUE;
                break;
            }
            case 17: 
            case 18: {
                this.prec = 8188;
                break;
            }
            case 12: {
                this.prec = Integer.MAX_VALUE;
                break;
            }
            case 14: {
                this.prec = 3;
                break;
            }
            case 15: {
                this.prec = 5;
                break;
            }
            case 16: {
                this.prec = 8;
                break;
            }
            case 23: {
                this.prec = 12;
                break;
            }
            case 22: {
                this.prec = 12;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                this.prec = 0;
                break;
            }
            case 25: 
            case 54: {
                this.type = 2;
                this.prec = 8188;
                break;
            }
        }
    }

    public void clear() {
        this.outJType = Integer.MIN_VALUE;
        this.outScale = -1;
        this.outObjectName = null;
        if (this.cursorStmt != null) {
            try {
                this.cursorStmt.do_close();
            }
            catch (SQLException sQLException) {}
        }
        this.cursorStmt = null;
    }

    public void close() {
        if (this.cursorStmt != null) {
            try {
                this.cursorStmt.do_close();
            }
            catch (SQLException sQLException) {}
        }
        this.cursorStmt = null;
    }

    public String toString() {
        return "[type: " + this.type + ", prec: " + this.prec + ", scale: " + this.scale + ", typeFlag: " + this.typeFlag + "]";
    }

    public int getIParam(NameBind nameBind) {
        return nameBind.iParam;
    }

    public Parameter clone(DmdbConnection dmdbConnection, DmdbPreparedStatement dmdbPreparedStatement) {
        Parameter parameter = new Parameter();
        parameter.baseName = this.baseName;
        parameter.identity = this.identity;
        parameter.isBdta = this.isBdta;
        parameter.lob = this.lob;
        parameter.lobColId = this.lobColId;
        parameter.lobTabId = this.lobTabId;
        parameter.name = this.name;
        parameter.nullable = this.nullable;
        parameter.prec = this.prec;
        parameter.readonly = this.readonly;
        parameter.scale = this.scale;
        parameter.schemaName = this.schemaName;
        parameter.tableName = this.tableName;
        parameter.type = this.type;
        parameter.typeDescriptor = this.typeDescriptor;
        parameter.typeName = this.typeName;
        parameter.hasDefault = this.hasDefault;
        parameter.ioType = this.ioType;
        parameter.outJType = this.outJType;
        parameter.outObjectName = this.outObjectName;
        parameter.outScale = this.outScale;
        parameter.typeFlag = this.typeFlag;
        if (this.cursorStmt != null && !this.cursorStmt.closed) {
            parameter.cursorStmt = dmdbConnection.do_createStatement(dmdbPreparedStatement.resultSetType, dmdbPreparedStatement.resultSetConcurrency, dmdbPreparedStatement.resultSetHoldability);
        }
        return parameter;
    }
}

