/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.OracleDateFormat$AMElement;
import dm.jdbc.util.OracleDateFormat$DDElement;
import dm.jdbc.util.OracleDateFormat$Element;
import dm.jdbc.util.OracleDateFormat$FElement;
import dm.jdbc.util.OracleDateFormat$HH12Element;
import dm.jdbc.util.OracleDateFormat$HH24Element;
import dm.jdbc.util.OracleDateFormat$MIElement;
import dm.jdbc.util.OracleDateFormat$MMElement;
import dm.jdbc.util.OracleDateFormat$MonElement;
import dm.jdbc.util.OracleDateFormat$MonthElement;
import dm.jdbc.util.OracleDateFormat$SSElement;
import dm.jdbc.util.OracleDateFormat$TZHElement;
import dm.jdbc.util.OracleDateFormat$TZMElement;
import dm.jdbc.util.OracleDateFormat$YearElement;
import dm.jdbc.util.StringUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OracleDateFormat {
    public int language = DmSvcConf.GLOBAL.getLanguage();
    public OracleDateFormat$YearElement Y = new OracleDateFormat$YearElement(this);
    public OracleDateFormat$HH12Element HH12 = new OracleDateFormat$HH12Element(this);
    public OracleDateFormat$HH24Element HH24 = new OracleDateFormat$HH24Element(this);
    public OracleDateFormat$MIElement MI = new OracleDateFormat$MIElement(this);
    public OracleDateFormat$SSElement SS = new OracleDateFormat$SSElement(this);
    public OracleDateFormat$AMElement AM = new OracleDateFormat$AMElement(this);
    public OracleDateFormat$MonthElement Month = new OracleDateFormat$MonthElement(this);
    public OracleDateFormat$MonElement Mon = new OracleDateFormat$MonElement(this);
    public OracleDateFormat$MMElement MM = new OracleDateFormat$MMElement(this);
    public OracleDateFormat$DDElement DD = new OracleDateFormat$DDElement(this);
    public OracleDateFormat$TZHElement TZH = new OracleDateFormat$TZHElement(this);
    public OracleDateFormat$TZMElement TZM = new OracleDateFormat$TZMElement(this);
    public OracleDateFormat$FElement F = new OracleDateFormat$FElement(this);
    public List formatElementList = new ArrayList();
    public String pattern;
    private static ThreadLocal formats = new ThreadLocal();
    boolean PM = false;
    boolean TZNegative = false;

    public void setPattern(String string) {
        if (!StringUtil.equals(string, this.pattern)) {
            this.pattern = string;
            this.formatElementList.clear();
            this.analysePattern(string);
        }
    }

    public int[] parse(String string) {
        this.clearBeforParse();
        int[] nArray = new int[8];
        Date date = new Date(System.currentTimeMillis());
        nArray[0] = date.getYear() + 1900;
        nArray[1] = date.getMonth() + 1;
        nArray[2] = date.getDate();
        nArray[7] = Integer.MIN_VALUE;
        int n2 = 0;
        try {
            string = string.trim();
            for (Object e2 : this.formatElementList) {
                while (string.charAt(n2) == ' ' && !StringUtil.equals(" ", e2.toString())) {
                    ++n2;
                }
                if (e2 instanceof OracleDateFormat$Element) {
                    n2 = ((OracleDateFormat$Element)e2).parse(string, n2, nArray);
                    continue;
                }
                n2 += e2.toString().length();
            }
            if (n2 < string.length()) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwException(new String[0]);
            }
            if (this.PM) {
                nArray[3] = (nArray[3] + 12) % 24;
            }
            if (this.TZNegative) {
                nArray[7] = -nArray[7];
            }
            if (nArray[2] > DateUtil.getDaysOfMonth(nArray[0], nArray[1]) || nArray[2] < 1) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwException(new String[0]);
            }
            if (nArray[7] != Integer.MIN_VALUE && (nArray[7] > 840 || nArray[7] <= -780)) {
                DBError.ECJDBC_INVALID_DATETIME_VALUE.throwException(new String[0]);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DBError.ECJDBC_INVALID_DATETIME_VALUE.errCode) {
                DBError.throwRuntimeException(sQLException.getMessage(), sQLException);
            }
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason, sQLException);
        }
        catch (Exception exception) {
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason, exception);
        }
        return nArray;
    }

    public static int[] parse(String string, String string2, int n2) {
        OracleDateFormat oracleDateFormat = OracleDateFormat.getFormat();
        oracleDateFormat.setPattern(string2);
        oracleDateFormat.language = n2;
        int[] nArray = oracleDateFormat.parse(string);
        return nArray;
    }

    public static String format(int[] nArray, String string, int n2) {
        OracleDateFormat oracleDateFormat = OracleDateFormat.getFormat();
        oracleDateFormat.setPattern(string);
        oracleDateFormat.language = n2;
        String string2 = oracleDateFormat.format(nArray);
        return string2;
    }

    public String format(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Object e2 : this.formatElementList) {
            if (!bl && (e2 instanceof OracleDateFormat$TZHElement || e2 instanceof OracleDateFormat$TZMElement)) {
                bl = true;
                stringBuilder.append(nArray[7] < 0 ? "-" : "+");
            }
            if (e2 instanceof OracleDateFormat$Element) {
                stringBuilder.append(((OracleDateFormat$Element)e2).format(nArray));
                continue;
            }
            stringBuilder.append(e2);
        }
        return stringBuilder.toString();
    }

    private void clearBeforParse() {
        this.PM = false;
        this.TZNegative = false;
    }

    private static OracleDateFormat getFormat() {
        OracleDateFormat oracleDateFormat = (OracleDateFormat)formats.get();
        if (oracleDateFormat == null) {
            oracleDateFormat = new OracleDateFormat();
        }
        return oracleDateFormat;
    }

    private List analysePattern(String string) {
        string = string.trim();
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        char c2 = '\u0000';
        int n4 = 0;
        while (n4 < n2) {
            c2 = string.charAt(n4);
            if (!Character.isLetterOrDigit(c2)) {
                if (n4 > n3) {
                    arrayList.add(string.substring(n3, n4));
                }
                arrayList.add(String.valueOf(c2));
                n3 = n4 + 1;
            } else if (n4 == n2 - 1) {
                arrayList.add(string.substring(n3, n4 + 1));
            }
            ++n4;
        }
        block1: for (String string2 : arrayList) {
            if (string2.length() != 1 || Character.isLetterOrDigit(string2.charAt(0))) {
                String string3 = string2;
                OracleDateFormat$Element oracleDateFormat$Element = null;
                while (string2 != null) {
                    int n5 = string2.length();
                    while (n5 > 0) {
                        string3 = string2.substring(0, n5);
                        oracleDateFormat$Element = this.getFormatElement(string3);
                        if (oracleDateFormat$Element != null) {
                            String string4;
                            if ((oracleDateFormat$Element == this.TZH || oracleDateFormat$Element == this.TZM) && ("+".equals(string4 = this.formatElementList.get(this.formatElementList.size() - 1).toString()) || "-".equals(string4))) {
                                this.formatElementList.remove(this.formatElementList.size() - 1);
                            }
                            this.formatElementList.add(oracleDateFormat$Element);
                            string2 = n5 == string2.length() ? null : string2.substring(n5, string2.length());
                            break;
                        }
                        --n5;
                    }
                    if (n5 != 0) continue;
                    this.formatElementList.add(string2);
                    continue block1;
                }
                continue;
            }
            this.formatElementList.add(string2);
        }
        return this.formatElementList;
    }

    private OracleDateFormat$Element getFormatElement(String string) {
        if ("HH".equalsIgnoreCase(string) || "HH12".equalsIgnoreCase(string)) {
            return this.HH12;
        }
        if ("HH24".equalsIgnoreCase(string)) {
            return this.HH24;
        }
        if ("MI".equalsIgnoreCase(string)) {
            return this.MI;
        }
        if ("SS".equalsIgnoreCase(string)) {
            return this.SS;
        }
        if ("AM".equalsIgnoreCase(string) || "A.M.".equalsIgnoreCase(string) || "PM".equalsIgnoreCase(string) || "P.M.".equalsIgnoreCase(string)) {
            return this.AM;
        }
        if ("MONTH".equals(string)) {
            this.Month.upperCase = true;
            this.Month.lowerCase = false;
            return this.Month;
        }
        if ("month".equals(string)) {
            this.Month.upperCase = false;
            this.Month.lowerCase = true;
            return this.Month;
        }
        if ("Month".equalsIgnoreCase(string)) {
            this.Month.upperCase = false;
            this.Month.lowerCase = false;
            return this.Month;
        }
        if ("MON".equals(string)) {
            this.Mon.upperCase = true;
            this.Mon.lowerCase = false;
            return this.Mon;
        }
        if ("mon".equals(string)) {
            this.Mon.upperCase = false;
            this.Mon.lowerCase = true;
            return this.Mon;
        }
        if ("Mon".equalsIgnoreCase(string)) {
            this.Mon.upperCase = false;
            this.Mon.lowerCase = false;
            return this.Mon;
        }
        if ("MM".equalsIgnoreCase(string)) {
            return this.MM;
        }
        if ("DD".equalsIgnoreCase(string)) {
            return this.DD;
        }
        if ("TZH".equalsIgnoreCase(string)) {
            return this.TZH;
        }
        if ("TZM".equalsIgnoreCase(string)) {
            return this.TZM;
        }
        if (string.startsWith("Y") || string.startsWith("y")) {
            this.Y.len = string.length();
            return this.Y;
        }
        if (string.startsWith("F") || string.startsWith("f")) {
            try {
                int n2;
                string = string.toUpperCase();
                int n3 = string.toUpperCase().lastIndexOf("F") + 1;
                this.F.len = n2 = n3 < string.length() ? Integer.valueOf(string.substring(n3, string.length())) : 9;
                return this.F;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String formatInt(int n2, int n3) {
        int n4 = (int)Math.pow(10.0, n3);
        if (n2 >= n4) {
            n2 %= n4;
        }
        return String.valueOf(n2 += n4).substring(1);
    }

    private String formatMilliSecond(int n2, int n3) {
        String string = null;
        string = n2 < 10 ? "00000" + n2 : (n2 < 100 ? "0000" + n2 : (n2 < 1000 ? "000" + n2 : (n2 < 10000 ? "00" + n2 : (n2 < 100000 ? "0" + n2 : Integer.toString(n2)))));
        if (n3 < 6) {
            string = string.substring(0, n3);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        int[] nArray = OracleDateFormat.parse("0:25:36.1", "HH12:MI:SS.FF", 1);
        System.out.println(Arrays.toString(nArray));
    }

    static /* synthetic */ String access$0(OracleDateFormat oracleDateFormat, int n2, int n3) {
        return oracleDateFormat.formatInt(n2, n3);
    }

    static /* synthetic */ String access$1(OracleDateFormat oracleDateFormat, int n2, int n3) {
        return oracleDateFormat.formatMilliSecond(n2, n3);
    }
}

