/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.config.common.internal.algorithm;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.config.common.internal.algorithm.ShardingValueWrapper;
import com.dangdang.ddframe.rdb.sharding.router.strategy.MultipleKeysShardingAlgorithm;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.util.Expando;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class ClosureShardingAlgorithm
implements MultipleKeysShardingAlgorithm {
    private final Closure<?> closureTemplate;

    public ClosureShardingAlgorithm(String expression, String logRoot) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)expression) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logRoot) ? 1 : 0) != 0);
        Binding binding = new Binding();
        binding.setVariable("log", (Object)LoggerFactory.getLogger((String)Joiner.on((String)".").join((Object)"com.dangdang.ddframe.rdb.sharding.configFile", (Object)logRoot.trim(), new Object[0])));
        this.closureTemplate = (Closure)new GroovyShell(binding).evaluate(Joiner.on((String)"").join((Object)"{it -> \"", (Object)expression.trim(), new Object[]{"\"}"}));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingValue<?>> shardingValues) {
        ArrayList<HashSet> valuesDim = new ArrayList<HashSet>();
        ArrayList<String> columnNames = new ArrayList<String>(shardingValues.size());
        block5: for (ShardingValue<?> each : shardingValues) {
            columnNames.add(each.getColumnName());
            switch (each.getType()) {
                case SINGLE: {
                    valuesDim.add(Sets.newHashSet((Object[])new Comparable[]{each.getValue()}));
                    continue block5;
                }
                case LIST: {
                    valuesDim.add(Sets.newHashSet((Iterable)each.getValues()));
                    continue block5;
                }
                case RANGE: {
                    throw new UnsupportedOperationException("Inline expression does not support BETWEEN, please use Java API Config");
                }
            }
            throw new UnsupportedOperationException(each.getType().name());
        }
        Set cartesianValues = Sets.cartesianProduct(valuesDim);
        ArrayList<String> result = new ArrayList<String>(cartesianValues.size());
        for (List each : cartesianValues) {
            result.add(this.cloneClosure(columnNames, each).call().toString());
        }
        return result;
    }

    private Closure<?> cloneClosure(List<String> columnNames, List<Comparable> values) {
        Closure result = this.closureTemplate.rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        result.setProperty("log", this.closureTemplate.getProperty("log"));
        for (int i = 0; i < values.size(); ++i) {
            result.setProperty(columnNames.get(i), (Object)new ShardingValueWrapper(values.get(i)));
        }
        return result;
    }
}

