/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.AccountUsersService;
import com.databricks.sdk.service.iam.DeleteAccountUserRequest;
import com.databricks.sdk.service.iam.GetAccountUserRequest;
import com.databricks.sdk.service.iam.ListAccountUsersRequest;
import com.databricks.sdk.service.iam.ListUsersResponse;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class AccountUsersImpl
implements AccountUsersService {
    private final ApiClient apiClient;

    public AccountUsersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public User create(User request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, User.class, headers);
    }

    @Override
    public void delete(DeleteAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public User get(GetAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, User.class, headers);
    }

    @Override
    public ListUsersResponse list(ListAccountUsersRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListUsersResponse.class, headers);
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, Void.class, headers);
    }

    @Override
    public void update(User request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PUT(path, request, Void.class, headers);
    }
}

