/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.CreateCredentials;
import com.databricks.sdk.service.workspace.CreateCredentialsResponse;
import com.databricks.sdk.service.workspace.CredentialInfo;
import com.databricks.sdk.service.workspace.DeleteGitCredentialRequest;
import com.databricks.sdk.service.workspace.GetGitCredentialRequest;
import com.databricks.sdk.service.workspace.GitCredentialsImpl;
import com.databricks.sdk.service.workspace.GitCredentialsService;
import com.databricks.sdk.service.workspace.UpdateCredentials;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class GitCredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GitCredentialsAPI.class);
    private final GitCredentialsService impl;

    public GitCredentialsAPI(ApiClient apiClient) {
        this.impl = new GitCredentialsImpl(apiClient);
    }

    public GitCredentialsAPI(GitCredentialsService mock) {
        this.impl = mock;
    }

    public CreateCredentialsResponse create(String gitProvider) {
        return this.create(new CreateCredentials().setGitProvider(gitProvider));
    }

    public CreateCredentialsResponse create(CreateCredentials request) {
        return this.impl.create(request);
    }

    public void delete(long credentialId) {
        this.delete(new DeleteGitCredentialRequest().setCredentialId(credentialId));
    }

    public void delete(DeleteGitCredentialRequest request) {
        this.impl.delete(request);
    }

    public CredentialInfo get(long credentialId) {
        return this.get(new GetGitCredentialRequest().setCredentialId(credentialId));
    }

    public CredentialInfo get(GetGitCredentialRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CredentialInfo> list() {
        return this.impl.list().getCredentials();
    }

    public void update(long credentialId) {
        this.update(new UpdateCredentials().setCredentialId(credentialId));
    }

    public void update(UpdateCredentials request) {
        this.impl.update(request);
    }

    public GitCredentialsService impl() {
        return this.impl;
    }
}

