/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.ColumnTypeName;
import com.databricks.sdk.service.catalog.CreateFunction;
import com.databricks.sdk.service.catalog.CreateFunctionParameterStyle;
import com.databricks.sdk.service.catalog.CreateFunctionRoutineBody;
import com.databricks.sdk.service.catalog.CreateFunctionSecurityType;
import com.databricks.sdk.service.catalog.CreateFunctionSqlDataAccess;
import com.databricks.sdk.service.catalog.DeleteFunctionRequest;
import com.databricks.sdk.service.catalog.Dependency;
import com.databricks.sdk.service.catalog.FunctionInfo;
import com.databricks.sdk.service.catalog.FunctionParameterInfo;
import com.databricks.sdk.service.catalog.FunctionsImpl;
import com.databricks.sdk.service.catalog.FunctionsService;
import com.databricks.sdk.service.catalog.GetFunctionRequest;
import com.databricks.sdk.service.catalog.ListFunctionsRequest;
import com.databricks.sdk.service.catalog.UpdateFunction;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FunctionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionsAPI.class);
    private final FunctionsService impl;

    public FunctionsAPI(ApiClient apiClient) {
        this.impl = new FunctionsImpl(apiClient);
    }

    public FunctionsAPI(FunctionsService mock) {
        this.impl = mock;
    }

    public FunctionInfo create(String name, String catalogName, String schemaName, Collection<FunctionParameterInfo> inputParams, ColumnTypeName dataType, String fullDataType, Collection<FunctionParameterInfo> returnParams, CreateFunctionRoutineBody routineBody, String routineDefinition, Collection<Dependency> routineDependencies, CreateFunctionParameterStyle parameterStyle, boolean isDeterministic, CreateFunctionSqlDataAccess sqlDataAccess, boolean isNullCall, CreateFunctionSecurityType securityType, String specificName) {
        return this.create(new CreateFunction().setName(name).setCatalogName(catalogName).setSchemaName(schemaName).setInputParams(inputParams).setDataType(dataType).setFullDataType(fullDataType).setReturnParams(returnParams).setRoutineBody(routineBody).setRoutineDefinition(routineDefinition).setRoutineDependencies(routineDependencies).setParameterStyle(parameterStyle).setIsDeterministic(isDeterministic).setSqlDataAccess(sqlDataAccess).setIsNullCall(isNullCall).setSecurityType(securityType).setSpecificName(specificName));
    }

    public FunctionInfo create(CreateFunction request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteFunctionRequest().setName(name));
    }

    public void delete(DeleteFunctionRequest request) {
        this.impl.delete(request);
    }

    public FunctionInfo get(String name) {
        return this.get(new GetFunctionRequest().setName(name));
    }

    public FunctionInfo get(GetFunctionRequest request) {
        return this.impl.get(request);
    }

    public Iterable<FunctionInfo> list(String catalogName, String schemaName) {
        return this.list(new ListFunctionsRequest().setCatalogName(catalogName).setSchemaName(schemaName));
    }

    public Iterable<FunctionInfo> list(ListFunctionsRequest request) {
        return this.impl.list(request).getFunctions();
    }

    public FunctionInfo update(String name) {
        return this.update(new UpdateFunction().setName(name));
    }

    public FunctionInfo update(UpdateFunction request) {
        return this.impl.update(request);
    }

    public FunctionsService impl() {
        return this.impl;
    }
}

