/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.AccountIpAccessListsImpl;
import com.databricks.sdk.service.settings.AccountIpAccessListsService;
import com.databricks.sdk.service.settings.CreateIpAccessList;
import com.databricks.sdk.service.settings.CreateIpAccessListResponse;
import com.databricks.sdk.service.settings.DeleteAccountIpAccessListRequest;
import com.databricks.sdk.service.settings.GetAccountIpAccessListRequest;
import com.databricks.sdk.service.settings.GetIpAccessListResponse;
import com.databricks.sdk.service.settings.IpAccessListInfo;
import com.databricks.sdk.service.settings.ListType;
import com.databricks.sdk.service.settings.ReplaceIpAccessList;
import com.databricks.sdk.service.settings.UpdateIpAccessList;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountIpAccessListsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountIpAccessListsAPI.class);
    private final AccountIpAccessListsService impl;

    public AccountIpAccessListsAPI(ApiClient apiClient) {
        this.impl = new AccountIpAccessListsImpl(apiClient);
    }

    public AccountIpAccessListsAPI(AccountIpAccessListsService mock) {
        this.impl = mock;
    }

    public CreateIpAccessListResponse create(String label, ListType listType, Collection<String> ipAddresses) {
        return this.create(new CreateIpAccessList().setLabel(label).setListType(listType).setIpAddresses(ipAddresses));
    }

    public CreateIpAccessListResponse create(CreateIpAccessList request) {
        return this.impl.create(request);
    }

    public void delete(String ipAccessListId) {
        this.delete(new DeleteAccountIpAccessListRequest().setIpAccessListId(ipAccessListId));
    }

    public void delete(DeleteAccountIpAccessListRequest request) {
        this.impl.delete(request);
    }

    public GetIpAccessListResponse get(String ipAccessListId) {
        return this.get(new GetAccountIpAccessListRequest().setIpAccessListId(ipAccessListId));
    }

    public GetIpAccessListResponse get(GetAccountIpAccessListRequest request) {
        return this.impl.get(request);
    }

    public Iterable<IpAccessListInfo> list() {
        return this.impl.list().getIpAccessLists();
    }

    public void replace(String label, ListType listType, Collection<String> ipAddresses, boolean enabled, String ipAccessListId) {
        this.replace(new ReplaceIpAccessList().setLabel(label).setListType(listType).setIpAddresses(ipAddresses).setEnabled(enabled).setIpAccessListId(ipAccessListId));
    }

    public void replace(ReplaceIpAccessList request) {
        this.impl.replace(request);
    }

    public void update(String label, ListType listType, Collection<String> ipAddresses, boolean enabled, String ipAccessListId) {
        this.update(new UpdateIpAccessList().setLabel(label).setListType(listType).setIpAddresses(ipAddresses).setEnabled(enabled).setIpAccessListId(ipAccessListId));
    }

    public void update(UpdateIpAccessList request) {
        this.impl.update(request);
    }

    public AccountIpAccessListsService impl() {
        return this.impl;
    }
}

