/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.CreateOboTokenRequest;
import com.databricks.sdk.service.settings.CreateOboTokenResponse;
import com.databricks.sdk.service.settings.DeleteTokenManagementRequest;
import com.databricks.sdk.service.settings.GetTokenManagementRequest;
import com.databricks.sdk.service.settings.GetTokenPermissionLevelsResponse;
import com.databricks.sdk.service.settings.ListTokenManagementRequest;
import com.databricks.sdk.service.settings.TokenInfo;
import com.databricks.sdk.service.settings.TokenManagementImpl;
import com.databricks.sdk.service.settings.TokenManagementService;
import com.databricks.sdk.service.settings.TokenPermissions;
import com.databricks.sdk.service.settings.TokenPermissionsRequest;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class TokenManagementAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TokenManagementAPI.class);
    private final TokenManagementService impl;

    public TokenManagementAPI(ApiClient apiClient) {
        this.impl = new TokenManagementImpl(apiClient);
    }

    public TokenManagementAPI(TokenManagementService mock) {
        this.impl = mock;
    }

    public CreateOboTokenResponse createOboToken(String applicationId, long lifetimeSeconds) {
        return this.createOboToken(new CreateOboTokenRequest().setApplicationId(applicationId).setLifetimeSeconds(lifetimeSeconds));
    }

    public CreateOboTokenResponse createOboToken(CreateOboTokenRequest request) {
        return this.impl.createOboToken(request);
    }

    public void delete(String tokenId) {
        this.delete(new DeleteTokenManagementRequest().setTokenId(tokenId));
    }

    public void delete(DeleteTokenManagementRequest request) {
        this.impl.delete(request);
    }

    public TokenInfo get(String tokenId) {
        return this.get(new GetTokenManagementRequest().setTokenId(tokenId));
    }

    public TokenInfo get(GetTokenManagementRequest request) {
        return this.impl.get(request);
    }

    public GetTokenPermissionLevelsResponse getTokenPermissionLevels() {
        return this.impl.getTokenPermissionLevels();
    }

    public TokenPermissions getTokenPermissions() {
        return this.impl.getTokenPermissions();
    }

    public Iterable<TokenInfo> list(ListTokenManagementRequest request) {
        return this.impl.list(request).getTokenInfos();
    }

    public TokenPermissions setTokenPermissions(TokenPermissionsRequest request) {
        return this.impl.setTokenPermissions(request);
    }

    public TokenPermissions updateTokenPermissions(TokenPermissionsRequest request) {
        return this.impl.updateTokenPermissions(request);
    }

    public TokenManagementService impl() {
        return this.impl;
    }
}

