/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sql.Alert;
import com.databricks.sdk.service.sql.AlertOptions;
import com.databricks.sdk.service.sql.AlertsImpl;
import com.databricks.sdk.service.sql.AlertsService;
import com.databricks.sdk.service.sql.CreateAlert;
import com.databricks.sdk.service.sql.DeleteAlertRequest;
import com.databricks.sdk.service.sql.EditAlert;
import com.databricks.sdk.service.sql.GetAlertRequest;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AlertsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsAPI.class);
    private final AlertsService impl;

    public AlertsAPI(ApiClient apiClient) {
        this.impl = new AlertsImpl(apiClient);
    }

    public AlertsAPI(AlertsService mock) {
        this.impl = mock;
    }

    public Alert create(String name, AlertOptions options, String queryId) {
        return this.create(new CreateAlert().setName(name).setOptions(options).setQueryId(queryId));
    }

    public Alert create(CreateAlert request) {
        return this.impl.create(request);
    }

    public void delete(String alertId) {
        this.delete(new DeleteAlertRequest().setAlertId(alertId));
    }

    public void delete(DeleteAlertRequest request) {
        this.impl.delete(request);
    }

    public Alert get(String alertId) {
        return this.get(new GetAlertRequest().setAlertId(alertId));
    }

    public Alert get(GetAlertRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Alert> list() {
        return this.impl.list();
    }

    public void update(String name, AlertOptions options, String queryId, String alertId) {
        this.update(new EditAlert().setName(name).setOptions(options).setQueryId(queryId).setAlertId(alertId));
    }

    public void update(EditAlert request) {
        this.impl.update(request);
    }

    public AlertsService impl() {
        return this.impl;
    }
}

