/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.support;

import com.databricks.sdk.support.Dedupe;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class Paginator<RQ, RS, T>
implements Iterable<T> {
    private final Function<RQ, RS> requestFn;
    private final Function<RS, Collection<T>> itemsFn;
    private final Function<RS, RQ> nextPageFn;
    private RS response;
    private Iterator<T> currentPage;
    private Iterator<T> all;

    public Paginator(RQ request, Function<RQ, RS> requestFn, Function<RS, Collection<T>> itemsFn, Function<RS, RQ> nextPageFn) {
        this.requestFn = requestFn;
        this.itemsFn = itemsFn;
        this.nextPageFn = nextPageFn;
        this.all = this.outerIterator();
        this.flipNextPage(request);
    }

    private boolean flipNextPage(RQ request) {
        if (request == null) {
            return false;
        }
        this.response = this.requestFn.apply(request);
        if (this.response == null) {
            return false;
        }
        Collection<T> results = this.itemsFn.apply(this.response);
        if (results == null) {
            return false;
        }
        this.currentPage = results.iterator();
        return this.currentPage.hasNext();
    }

    private Iterator<T> outerIterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (Paginator.this.currentPage == null) {
                    return false;
                }
                if (Paginator.this.currentPage.hasNext()) {
                    return true;
                }
                return Paginator.this.flipNextPage(Paginator.this.nextPageFn.apply(Paginator.this.response));
            }

            @Override
            public T next() {
                return Paginator.this.currentPage.next();
            }
        };
    }

    public <ID> Iterable<T> withDedupe(Function<T, ID> idGetter) {
        this.all = new Dedupe<T, ID>(this.all, idGetter);
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.all;
    }
}

