/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ServiceCheckStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing service check and status.")
@JsonPropertyOrder(value={"check", "host_name", "message", "status", "tags", "timestamp"})
public class ServiceCheck {
    public static final String JSON_PROPERTY_CHECK = "check";
    private String check;
    public static final String JSON_PROPERTY_HOST_NAME = "host_name";
    private String hostName;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ServiceCheckStatus status;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public ServiceCheck check(String check) {
        this.check = check;
        return this;
    }

    @ApiModelProperty(example="app.ok", required=true, value="The check.")
    @JsonProperty(value="check")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public ServiceCheck hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @ApiModelProperty(example="app.host1", required=true, value="The host name correlated with the check.")
    @JsonProperty(value="host_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public ServiceCheck message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="app is running", value="Message containing check status.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ServiceCheck status(ServiceCheckStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceCheckStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServiceCheckStatus status) {
        this.status = status;
    }

    public ServiceCheck tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ServiceCheck addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"environment:test\"]", required=true, value="Tags related to a check.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ServiceCheck timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time of check.")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCheck serviceCheck = (ServiceCheck)o;
        return Objects.equals(this.check, serviceCheck.check) && Objects.equals(this.hostName, serviceCheck.hostName) && Objects.equals(this.message, serviceCheck.message) && Objects.equals((Object)this.status, (Object)serviceCheck.status) && Objects.equals(this.tags, serviceCheck.tags) && Objects.equals(this.timestamp, serviceCheck.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.check, this.hostName, this.message, this.status, this.tags, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCheck {\n");
        sb.append("    check: ").append(this.toIndentedString(this.check)).append("\n");
        sb.append("    hostName: ").append(this.toIndentedString(this.hostName)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

