/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fields in Usage Summary by tag(s).")
@JsonPropertyOrder(value={"api_percentage", "api_usage", "apm_host_percentage", "apm_host_usage", "browser_percentage", "browser_usage", "container_percentage", "container_usage", "custom_timeseries_percentage", "custom_timeseries_usage", "infra_host_percentage", "infra_host_usage", "lambda_functions_percentage", "lambda_functions_usage", "lambda_invocations_percentage", "lambda_invocations_usage", "lambda_percentage", "lambda_usage", "npm_host_percentage", "npm_host_usage", "profiled_containers_percentage", "profiled_containers_usage", "profiled_hosts_percentage", "profiled_hosts_usage", "snmp_percentage", "snmp_usage"})
public class UsageAttributionValues {
    public static final String JSON_PROPERTY_API_PERCENTAGE = "api_percentage";
    private Double apiPercentage;
    public static final String JSON_PROPERTY_API_USAGE = "api_usage";
    private Double apiUsage;
    public static final String JSON_PROPERTY_APM_HOST_PERCENTAGE = "apm_host_percentage";
    private Double apmHostPercentage;
    public static final String JSON_PROPERTY_APM_HOST_USAGE = "apm_host_usage";
    private Double apmHostUsage;
    public static final String JSON_PROPERTY_BROWSER_PERCENTAGE = "browser_percentage";
    private Double browserPercentage;
    public static final String JSON_PROPERTY_BROWSER_USAGE = "browser_usage";
    private Double browserUsage;
    public static final String JSON_PROPERTY_CONTAINER_PERCENTAGE = "container_percentage";
    private Double containerPercentage;
    public static final String JSON_PROPERTY_CONTAINER_USAGE = "container_usage";
    private Double containerUsage;
    public static final String JSON_PROPERTY_CUSTOM_TIMESERIES_PERCENTAGE = "custom_timeseries_percentage";
    private Double customTimeseriesPercentage;
    public static final String JSON_PROPERTY_CUSTOM_TIMESERIES_USAGE = "custom_timeseries_usage";
    private Double customTimeseriesUsage;
    public static final String JSON_PROPERTY_INFRA_HOST_PERCENTAGE = "infra_host_percentage";
    private Double infraHostPercentage;
    public static final String JSON_PROPERTY_INFRA_HOST_USAGE = "infra_host_usage";
    private Double infraHostUsage;
    public static final String JSON_PROPERTY_LAMBDA_FUNCTIONS_PERCENTAGE = "lambda_functions_percentage";
    private Double lambdaFunctionsPercentage;
    public static final String JSON_PROPERTY_LAMBDA_FUNCTIONS_USAGE = "lambda_functions_usage";
    private Double lambdaFunctionsUsage;
    public static final String JSON_PROPERTY_LAMBDA_INVOCATIONS_PERCENTAGE = "lambda_invocations_percentage";
    private Double lambdaInvocationsPercentage;
    public static final String JSON_PROPERTY_LAMBDA_INVOCATIONS_USAGE = "lambda_invocations_usage";
    private Double lambdaInvocationsUsage;
    public static final String JSON_PROPERTY_LAMBDA_PERCENTAGE = "lambda_percentage";
    private Double lambdaPercentage;
    public static final String JSON_PROPERTY_LAMBDA_USAGE = "lambda_usage";
    private Double lambdaUsage;
    public static final String JSON_PROPERTY_NPM_HOST_PERCENTAGE = "npm_host_percentage";
    private Double npmHostPercentage;
    public static final String JSON_PROPERTY_NPM_HOST_USAGE = "npm_host_usage";
    private Double npmHostUsage;
    public static final String JSON_PROPERTY_PROFILED_CONTAINERS_PERCENTAGE = "profiled_containers_percentage";
    private Double profiledContainersPercentage;
    public static final String JSON_PROPERTY_PROFILED_CONTAINERS_USAGE = "profiled_containers_usage";
    private Double profiledContainersUsage;
    public static final String JSON_PROPERTY_PROFILED_HOSTS_PERCENTAGE = "profiled_hosts_percentage";
    private Double profiledHostsPercentage;
    public static final String JSON_PROPERTY_PROFILED_HOSTS_USAGE = "profiled_hosts_usage";
    private Double profiledHostsUsage;
    public static final String JSON_PROPERTY_SNMP_PERCENTAGE = "snmp_percentage";
    private Double snmpPercentage;
    public static final String JSON_PROPERTY_SNMP_USAGE = "snmp_usage";
    private Double snmpUsage;

    public UsageAttributionValues apiPercentage(Double apiPercentage) {
        this.apiPercentage = apiPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of synthetic API test usage by tag(s).")
    @JsonProperty(value="api_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApiPercentage() {
        return this.apiPercentage;
    }

    public void setApiPercentage(Double apiPercentage) {
        this.apiPercentage = apiPercentage;
    }

    public UsageAttributionValues apiUsage(Double apiUsage) {
        this.apiUsage = apiUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The synthetic API test usage by tag(s).")
    @JsonProperty(value="api_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApiUsage() {
        return this.apiUsage;
    }

    public void setApiUsage(Double apiUsage) {
        this.apiUsage = apiUsage;
    }

    public UsageAttributionValues apmHostPercentage(Double apmHostPercentage) {
        this.apmHostPercentage = apmHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of APM host usage by tag(s).")
    @JsonProperty(value="apm_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApmHostPercentage() {
        return this.apmHostPercentage;
    }

    public void setApmHostPercentage(Double apmHostPercentage) {
        this.apmHostPercentage = apmHostPercentage;
    }

    public UsageAttributionValues apmHostUsage(Double apmHostUsage) {
        this.apmHostUsage = apmHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The APM host usage by tag(s).")
    @JsonProperty(value="apm_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getApmHostUsage() {
        return this.apmHostUsage;
    }

    public void setApmHostUsage(Double apmHostUsage) {
        this.apmHostUsage = apmHostUsage;
    }

    public UsageAttributionValues browserPercentage(Double browserPercentage) {
        this.browserPercentage = browserPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of synthetic browser test usage by tag(s).")
    @JsonProperty(value="browser_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBrowserPercentage() {
        return this.browserPercentage;
    }

    public void setBrowserPercentage(Double browserPercentage) {
        this.browserPercentage = browserPercentage;
    }

    public UsageAttributionValues browserUsage(Double browserUsage) {
        this.browserUsage = browserUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The synthetic browser test usage by tag(s).")
    @JsonProperty(value="browser_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBrowserUsage() {
        return this.browserUsage;
    }

    public void setBrowserUsage(Double browserUsage) {
        this.browserUsage = browserUsage;
    }

    public UsageAttributionValues containerPercentage(Double containerPercentage) {
        this.containerPercentage = containerPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of container usage by tag(s).")
    @JsonProperty(value="container_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getContainerPercentage() {
        return this.containerPercentage;
    }

    public void setContainerPercentage(Double containerPercentage) {
        this.containerPercentage = containerPercentage;
    }

    public UsageAttributionValues containerUsage(Double containerUsage) {
        this.containerUsage = containerUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The container usage by tag(s).")
    @JsonProperty(value="container_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getContainerUsage() {
        return this.containerUsage;
    }

    public void setContainerUsage(Double containerUsage) {
        this.containerUsage = containerUsage;
    }

    public UsageAttributionValues customTimeseriesPercentage(Double customTimeseriesPercentage) {
        this.customTimeseriesPercentage = customTimeseriesPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of custom metrics usage by tag(s).")
    @JsonProperty(value="custom_timeseries_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCustomTimeseriesPercentage() {
        return this.customTimeseriesPercentage;
    }

    public void setCustomTimeseriesPercentage(Double customTimeseriesPercentage) {
        this.customTimeseriesPercentage = customTimeseriesPercentage;
    }

    public UsageAttributionValues customTimeseriesUsage(Double customTimeseriesUsage) {
        this.customTimeseriesUsage = customTimeseriesUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The custom metrics usage by tag(s).")
    @JsonProperty(value="custom_timeseries_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCustomTimeseriesUsage() {
        return this.customTimeseriesUsage;
    }

    public void setCustomTimeseriesUsage(Double customTimeseriesUsage) {
        this.customTimeseriesUsage = customTimeseriesUsage;
    }

    public UsageAttributionValues infraHostPercentage(Double infraHostPercentage) {
        this.infraHostPercentage = infraHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of infrastructure host usage by tag(s).")
    @JsonProperty(value="infra_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInfraHostPercentage() {
        return this.infraHostPercentage;
    }

    public void setInfraHostPercentage(Double infraHostPercentage) {
        this.infraHostPercentage = infraHostPercentage;
    }

    public UsageAttributionValues infraHostUsage(Double infraHostUsage) {
        this.infraHostUsage = infraHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The infrastructure host usage by tag(s).")
    @JsonProperty(value="infra_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInfraHostUsage() {
        return this.infraHostUsage;
    }

    public void setInfraHostUsage(Double infraHostUsage) {
        this.infraHostUsage = infraHostUsage;
    }

    public UsageAttributionValues lambdaFunctionsPercentage(Double lambdaFunctionsPercentage) {
        this.lambdaFunctionsPercentage = lambdaFunctionsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of Lambda function usage by tag(s).")
    @JsonProperty(value="lambda_functions_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLambdaFunctionsPercentage() {
        return this.lambdaFunctionsPercentage;
    }

    public void setLambdaFunctionsPercentage(Double lambdaFunctionsPercentage) {
        this.lambdaFunctionsPercentage = lambdaFunctionsPercentage;
    }

    public UsageAttributionValues lambdaFunctionsUsage(Double lambdaFunctionsUsage) {
        this.lambdaFunctionsUsage = lambdaFunctionsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Lambda function usage by tag(s).")
    @JsonProperty(value="lambda_functions_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLambdaFunctionsUsage() {
        return this.lambdaFunctionsUsage;
    }

    public void setLambdaFunctionsUsage(Double lambdaFunctionsUsage) {
        this.lambdaFunctionsUsage = lambdaFunctionsUsage;
    }

    public UsageAttributionValues lambdaInvocationsPercentage(Double lambdaInvocationsPercentage) {
        this.lambdaInvocationsPercentage = lambdaInvocationsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of Lambda invocation usage by tag(s).")
    @JsonProperty(value="lambda_invocations_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLambdaInvocationsPercentage() {
        return this.lambdaInvocationsPercentage;
    }

    public void setLambdaInvocationsPercentage(Double lambdaInvocationsPercentage) {
        this.lambdaInvocationsPercentage = lambdaInvocationsPercentage;
    }

    public UsageAttributionValues lambdaInvocationsUsage(Double lambdaInvocationsUsage) {
        this.lambdaInvocationsUsage = lambdaInvocationsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Lambda invocation usage by tag(s).")
    @JsonProperty(value="lambda_invocations_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLambdaInvocationsUsage() {
        return this.lambdaInvocationsUsage;
    }

    public void setLambdaInvocationsUsage(Double lambdaInvocationsUsage) {
        this.lambdaInvocationsUsage = lambdaInvocationsUsage;
    }

    public UsageAttributionValues lambdaPercentage(Double lambdaPercentage) {
        this.lambdaPercentage = lambdaPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of Lambda function usage by tag(s).  **Note** this field is deprecated. Use lambda_functions_percentage instead.")
    @JsonProperty(value="lambda_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLambdaPercentage() {
        return this.lambdaPercentage;
    }

    public void setLambdaPercentage(Double lambdaPercentage) {
        this.lambdaPercentage = lambdaPercentage;
    }

    public UsageAttributionValues lambdaUsage(Double lambdaUsage) {
        this.lambdaUsage = lambdaUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Lambda function usage by tag(s).  **Note** this field is deprecated. Use lambda_functions_usage instead.")
    @JsonProperty(value="lambda_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLambdaUsage() {
        return this.lambdaUsage;
    }

    public void setLambdaUsage(Double lambdaUsage) {
        this.lambdaUsage = lambdaUsage;
    }

    public UsageAttributionValues npmHostPercentage(Double npmHostPercentage) {
        this.npmHostPercentage = npmHostPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of network host usage by tag(s).")
    @JsonProperty(value="npm_host_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNpmHostPercentage() {
        return this.npmHostPercentage;
    }

    public void setNpmHostPercentage(Double npmHostPercentage) {
        this.npmHostPercentage = npmHostPercentage;
    }

    public UsageAttributionValues npmHostUsage(Double npmHostUsage) {
        this.npmHostUsage = npmHostUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network host usage by tag(s).")
    @JsonProperty(value="npm_host_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getNpmHostUsage() {
        return this.npmHostUsage;
    }

    public void setNpmHostUsage(Double npmHostUsage) {
        this.npmHostUsage = npmHostUsage;
    }

    public UsageAttributionValues profiledContainersPercentage(Double profiledContainersPercentage) {
        this.profiledContainersPercentage = profiledContainersPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of profiled containers usage by tag(s).")
    @JsonProperty(value="profiled_containers_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledContainersPercentage() {
        return this.profiledContainersPercentage;
    }

    public void setProfiledContainersPercentage(Double profiledContainersPercentage) {
        this.profiledContainersPercentage = profiledContainersPercentage;
    }

    public UsageAttributionValues profiledContainersUsage(Double profiledContainersUsage) {
        this.profiledContainersUsage = profiledContainersUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The profiled container usage by tag(s).")
    @JsonProperty(value="profiled_containers_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledContainersUsage() {
        return this.profiledContainersUsage;
    }

    public void setProfiledContainersUsage(Double profiledContainersUsage) {
        this.profiledContainersUsage = profiledContainersUsage;
    }

    public UsageAttributionValues profiledHostsPercentage(Double profiledHostsPercentage) {
        this.profiledHostsPercentage = profiledHostsPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of profiled hosts usage by tag(s).")
    @JsonProperty(value="profiled_hosts_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledHostsPercentage() {
        return this.profiledHostsPercentage;
    }

    public void setProfiledHostsPercentage(Double profiledHostsPercentage) {
        this.profiledHostsPercentage = profiledHostsPercentage;
    }

    public UsageAttributionValues profiledHostsUsage(Double profiledHostsUsage) {
        this.profiledHostsUsage = profiledHostsUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The profiled host usage by tag(s).")
    @JsonProperty(value="profiled_hosts_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProfiledHostsUsage() {
        return this.profiledHostsUsage;
    }

    public void setProfiledHostsUsage(Double profiledHostsUsage) {
        this.profiledHostsUsage = profiledHostsUsage;
    }

    public UsageAttributionValues snmpPercentage(Double snmpPercentage) {
        this.snmpPercentage = snmpPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage of network device usage by tag(s).")
    @JsonProperty(value="snmp_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSnmpPercentage() {
        return this.snmpPercentage;
    }

    public void setSnmpPercentage(Double snmpPercentage) {
        this.snmpPercentage = snmpPercentage;
    }

    public UsageAttributionValues snmpUsage(Double snmpUsage) {
        this.snmpUsage = snmpUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network device usage by tag(s).")
    @JsonProperty(value="snmp_usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSnmpUsage() {
        return this.snmpUsage;
    }

    public void setSnmpUsage(Double snmpUsage) {
        this.snmpUsage = snmpUsage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionValues usageAttributionValues = (UsageAttributionValues)o;
        return Objects.equals(this.apiPercentage, usageAttributionValues.apiPercentage) && Objects.equals(this.apiUsage, usageAttributionValues.apiUsage) && Objects.equals(this.apmHostPercentage, usageAttributionValues.apmHostPercentage) && Objects.equals(this.apmHostUsage, usageAttributionValues.apmHostUsage) && Objects.equals(this.browserPercentage, usageAttributionValues.browserPercentage) && Objects.equals(this.browserUsage, usageAttributionValues.browserUsage) && Objects.equals(this.containerPercentage, usageAttributionValues.containerPercentage) && Objects.equals(this.containerUsage, usageAttributionValues.containerUsage) && Objects.equals(this.customTimeseriesPercentage, usageAttributionValues.customTimeseriesPercentage) && Objects.equals(this.customTimeseriesUsage, usageAttributionValues.customTimeseriesUsage) && Objects.equals(this.infraHostPercentage, usageAttributionValues.infraHostPercentage) && Objects.equals(this.infraHostUsage, usageAttributionValues.infraHostUsage) && Objects.equals(this.lambdaFunctionsPercentage, usageAttributionValues.lambdaFunctionsPercentage) && Objects.equals(this.lambdaFunctionsUsage, usageAttributionValues.lambdaFunctionsUsage) && Objects.equals(this.lambdaInvocationsPercentage, usageAttributionValues.lambdaInvocationsPercentage) && Objects.equals(this.lambdaInvocationsUsage, usageAttributionValues.lambdaInvocationsUsage) && Objects.equals(this.lambdaPercentage, usageAttributionValues.lambdaPercentage) && Objects.equals(this.lambdaUsage, usageAttributionValues.lambdaUsage) && Objects.equals(this.npmHostPercentage, usageAttributionValues.npmHostPercentage) && Objects.equals(this.npmHostUsage, usageAttributionValues.npmHostUsage) && Objects.equals(this.profiledContainersPercentage, usageAttributionValues.profiledContainersPercentage) && Objects.equals(this.profiledContainersUsage, usageAttributionValues.profiledContainersUsage) && Objects.equals(this.profiledHostsPercentage, usageAttributionValues.profiledHostsPercentage) && Objects.equals(this.profiledHostsUsage, usageAttributionValues.profiledHostsUsage) && Objects.equals(this.snmpPercentage, usageAttributionValues.snmpPercentage) && Objects.equals(this.snmpUsage, usageAttributionValues.snmpUsage);
    }

    public int hashCode() {
        return Objects.hash(this.apiPercentage, this.apiUsage, this.apmHostPercentage, this.apmHostUsage, this.browserPercentage, this.browserUsage, this.containerPercentage, this.containerUsage, this.customTimeseriesPercentage, this.customTimeseriesUsage, this.infraHostPercentage, this.infraHostUsage, this.lambdaFunctionsPercentage, this.lambdaFunctionsUsage, this.lambdaInvocationsPercentage, this.lambdaInvocationsUsage, this.lambdaPercentage, this.lambdaUsage, this.npmHostPercentage, this.npmHostUsage, this.profiledContainersPercentage, this.profiledContainersUsage, this.profiledHostsPercentage, this.profiledHostsUsage, this.snmpPercentage, this.snmpUsage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionValues {\n");
        sb.append("    apiPercentage: ").append(this.toIndentedString(this.apiPercentage)).append("\n");
        sb.append("    apiUsage: ").append(this.toIndentedString(this.apiUsage)).append("\n");
        sb.append("    apmHostPercentage: ").append(this.toIndentedString(this.apmHostPercentage)).append("\n");
        sb.append("    apmHostUsage: ").append(this.toIndentedString(this.apmHostUsage)).append("\n");
        sb.append("    browserPercentage: ").append(this.toIndentedString(this.browserPercentage)).append("\n");
        sb.append("    browserUsage: ").append(this.toIndentedString(this.browserUsage)).append("\n");
        sb.append("    containerPercentage: ").append(this.toIndentedString(this.containerPercentage)).append("\n");
        sb.append("    containerUsage: ").append(this.toIndentedString(this.containerUsage)).append("\n");
        sb.append("    customTimeseriesPercentage: ").append(this.toIndentedString(this.customTimeseriesPercentage)).append("\n");
        sb.append("    customTimeseriesUsage: ").append(this.toIndentedString(this.customTimeseriesUsage)).append("\n");
        sb.append("    infraHostPercentage: ").append(this.toIndentedString(this.infraHostPercentage)).append("\n");
        sb.append("    infraHostUsage: ").append(this.toIndentedString(this.infraHostUsage)).append("\n");
        sb.append("    lambdaFunctionsPercentage: ").append(this.toIndentedString(this.lambdaFunctionsPercentage)).append("\n");
        sb.append("    lambdaFunctionsUsage: ").append(this.toIndentedString(this.lambdaFunctionsUsage)).append("\n");
        sb.append("    lambdaInvocationsPercentage: ").append(this.toIndentedString(this.lambdaInvocationsPercentage)).append("\n");
        sb.append("    lambdaInvocationsUsage: ").append(this.toIndentedString(this.lambdaInvocationsUsage)).append("\n");
        sb.append("    lambdaPercentage: ").append(this.toIndentedString(this.lambdaPercentage)).append("\n");
        sb.append("    lambdaUsage: ").append(this.toIndentedString(this.lambdaUsage)).append("\n");
        sb.append("    npmHostPercentage: ").append(this.toIndentedString(this.npmHostPercentage)).append("\n");
        sb.append("    npmHostUsage: ").append(this.toIndentedString(this.npmHostUsage)).append("\n");
        sb.append("    profiledContainersPercentage: ").append(this.toIndentedString(this.profiledContainersPercentage)).append("\n");
        sb.append("    profiledContainersUsage: ").append(this.toIndentedString(this.profiledContainersUsage)).append("\n");
        sb.append("    profiledHostsPercentage: ").append(this.toIndentedString(this.profiledHostsPercentage)).append("\n");
        sb.append("    profiledHostsUsage: ").append(this.toIndentedString(this.profiledHostsUsage)).append("\n");
        sb.append("    snmpPercentage: ").append(this.toIndentedString(this.snmpPercentage)).append("\n");
        sb.append("    snmpUsage: ").append(this.toIndentedString(this.snmpUsage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

