/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.WidgetComparator;
import com.datadog.api.v1.client.model.WidgetPalette;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Define a conditional format for the widget.")
@JsonPropertyOrder(value={"comparator", "custom_bg_color", "custom_fg_color", "hide_value", "image_url", "metric", "palette", "timeframe", "value"})
public class WidgetConditionalFormat {
    public static final String JSON_PROPERTY_COMPARATOR = "comparator";
    private WidgetComparator comparator;
    public static final String JSON_PROPERTY_CUSTOM_BG_COLOR = "custom_bg_color";
    private String customBgColor;
    public static final String JSON_PROPERTY_CUSTOM_FG_COLOR = "custom_fg_color";
    private String customFgColor;
    public static final String JSON_PROPERTY_HIDE_VALUE = "hide_value";
    private Boolean hideValue;
    public static final String JSON_PROPERTY_IMAGE_URL = "image_url";
    private String imageUrl;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_PALETTE = "palette";
    private WidgetPalette palette;
    public static final String JSON_PROPERTY_TIMEFRAME = "timeframe";
    private String timeframe;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Double value;

    public WidgetConditionalFormat comparator(WidgetComparator comparator) {
        this.comparator = comparator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="comparator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(WidgetComparator comparator) {
        this.comparator = comparator;
    }

    public WidgetConditionalFormat customBgColor(String customBgColor) {
        this.customBgColor = customBgColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color palette to apply to the background, same values available as palette.")
    @JsonProperty(value="custom_bg_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomBgColor() {
        return this.customBgColor;
    }

    public void setCustomBgColor(String customBgColor) {
        this.customBgColor = customBgColor;
    }

    public WidgetConditionalFormat customFgColor(String customFgColor) {
        this.customFgColor = customFgColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Color palette to apply to the foreground, same values available as palette.")
    @JsonProperty(value="custom_fg_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomFgColor() {
        return this.customFgColor;
    }

    public void setCustomFgColor(String customFgColor) {
        this.customFgColor = customFgColor;
    }

    public WidgetConditionalFormat hideValue(Boolean hideValue) {
        this.hideValue = hideValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True hides values.")
    @JsonProperty(value="hide_value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideValue() {
        return this.hideValue;
    }

    public void setHideValue(Boolean hideValue) {
        this.hideValue = hideValue;
    }

    public WidgetConditionalFormat imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Displays an image as the background.")
    @JsonProperty(value="image_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public WidgetConditionalFormat metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Metric from the request to correlate this conditional format with.")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public WidgetConditionalFormat palette(WidgetPalette palette) {
        this.palette = palette;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="palette")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetPalette getPalette() {
        return this.palette;
    }

    public void setPalette(WidgetPalette palette) {
        this.palette = palette;
    }

    public WidgetConditionalFormat timeframe(String timeframe) {
        this.timeframe = timeframe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines the displayed timeframe.")
    @JsonProperty(value="timeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(String timeframe) {
        this.timeframe = timeframe;
    }

    public WidgetConditionalFormat value(Double value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="0.0", required=true, value="Value for the comparator.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetConditionalFormat widgetConditionalFormat = (WidgetConditionalFormat)o;
        return Objects.equals((Object)this.comparator, (Object)widgetConditionalFormat.comparator) && Objects.equals(this.customBgColor, widgetConditionalFormat.customBgColor) && Objects.equals(this.customFgColor, widgetConditionalFormat.customFgColor) && Objects.equals(this.hideValue, widgetConditionalFormat.hideValue) && Objects.equals(this.imageUrl, widgetConditionalFormat.imageUrl) && Objects.equals(this.metric, widgetConditionalFormat.metric) && Objects.equals((Object)this.palette, (Object)widgetConditionalFormat.palette) && Objects.equals(this.timeframe, widgetConditionalFormat.timeframe) && Objects.equals(this.value, widgetConditionalFormat.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.comparator, this.customBgColor, this.customFgColor, this.hideValue, this.imageUrl, this.metric, this.palette, this.timeframe, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetConditionalFormat {\n");
        sb.append("    comparator: ").append(this.toIndentedString((Object)this.comparator)).append("\n");
        sb.append("    customBgColor: ").append(this.toIndentedString(this.customBgColor)).append("\n");
        sb.append("    customFgColor: ").append(this.toIndentedString(this.customFgColor)).append("\n");
        sb.append("    hideValue: ").append(this.toIndentedString(this.hideValue)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    palette: ").append(this.toIndentedString((Object)this.palette)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

