/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.SecurityMonitoringListRulesResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleCreatePayload;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleUpdatePayload;
import com.datadog.api.v2.client.model.SecurityMonitoringSignalListRequest;
import com.datadog.api.v2.client.model.SecurityMonitoringSignalsListResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringSignalsSort;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class SecurityMonitoringApi {
    private ApiClient apiClient;

    public SecurityMonitoringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecurityMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SecurityMonitoringRuleResponse createSecurityMonitoringRule(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        return this.createSecurityMonitoringRuleWithHttpInfo(body).getData();
    }

    public ApiResponse<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringRuleResponse> localVarReturnType = new GenericType<SecurityMonitoringRuleResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteSecurityMonitoringRule(String ruleId) throws ApiException {
        this.deleteSecurityMonitoringRuleWithHttpInfo(ruleId);
    }

    public ApiResponse<Void> deleteSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public SecurityMonitoringRuleResponse getSecurityMonitoringRule(String ruleId) throws ApiException {
        return this.getSecurityMonitoringRuleWithHttpInfo(ruleId).getData();
    }

    public ApiResponse<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringRuleResponse> localVarReturnType = new GenericType<SecurityMonitoringRuleResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules() throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(new ListSecurityMonitoringRulesOptionalParameters()).getData();
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(parameters).getData();
    }

    public ApiResponse<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesWithHttpInfo(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarHeaderParams.put("DD-OPERATION-ID", "listSecurityMonitoringRules");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringListRulesResponse> localVarReturnType = new GenericType<SecurityMonitoringListRulesResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals() throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(new ListSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsWithHttpInfo(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarHeaderParams.put("DD-OPERATION-ID", "listSecurityMonitoringSignals");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringSignalsListResponse> localVarReturnType = new GenericType<SecurityMonitoringSignalsListResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals() throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(new SearchSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsWithHttpInfo(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "searchSecurityMonitoringSignals");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringSignalsListResponse> localVarReturnType = new GenericType<SecurityMonitoringSignalsListResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SecurityMonitoringRuleResponse updateSecurityMonitoringRule(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        return this.updateSecurityMonitoringRuleWithHttpInfo(ruleId, body).getData();
    }

    public ApiResponse<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleWithHttpInfo(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringRuleResponse> localVarReturnType = new GenericType<SecurityMonitoringRuleResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class SearchSecurityMonitoringSignalsOptionalParameters {
        private SecurityMonitoringSignalListRequest body;

        public SearchSecurityMonitoringSignalsOptionalParameters body(SecurityMonitoringSignalListRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListSecurityMonitoringSignalsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private SecurityMonitoringSignalsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListSecurityMonitoringSignalsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters sort(SecurityMonitoringSignalsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListSecurityMonitoringRulesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListSecurityMonitoringRulesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListSecurityMonitoringRulesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

