/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsArchiveCreateRequestDestination;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attributes associated with the archive.")
@JsonPropertyOrder(value={"destination", "include_tags", "name", "query", "rehydration_tags"})
public class LogsArchiveCreateRequestAttributes {
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private LogsArchiveCreateRequestDestination destination;
    public static final String JSON_PROPERTY_INCLUDE_TAGS = "include_tags";
    private Boolean includeTags = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_REHYDRATION_TAGS = "rehydration_tags";
    private List<String> rehydrationTags = null;

    public LogsArchiveCreateRequestAttributes destination(LogsArchiveCreateRequestDestination destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveCreateRequestDestination getDestination() {
        return this.destination;
    }

    public void setDestination(LogsArchiveCreateRequestDestination destination) {
        this.destination = destination;
    }

    public LogsArchiveCreateRequestAttributes includeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="To store the tags in the archive, set the value \"true\". If it is set to \"false\", the tags will be deleted when the logs are sent to the archive.")
    @JsonProperty(value="include_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public LogsArchiveCreateRequestAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Nginx Archive", required=true, value="The archive name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsArchiveCreateRequestAttributes query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="source:nginx", required=true, value="The archive query/filter. Logs matching this query are included in the archive.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsArchiveCreateRequestAttributes rehydrationTags(List<String> rehydrationTags) {
        this.rehydrationTags = rehydrationTags;
        return this;
    }

    public LogsArchiveCreateRequestAttributes addRehydrationTagsItem(String rehydrationTagsItem) {
        if (this.rehydrationTags == null) {
            this.rehydrationTags = new ArrayList<String>();
        }
        this.rehydrationTags.add(rehydrationTagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"team:intake\",\"team:app\"]", value="An array of tags to add to rehydrated logs from an archive.")
    @JsonProperty(value="rehydration_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRehydrationTags() {
        return this.rehydrationTags;
    }

    public void setRehydrationTags(List<String> rehydrationTags) {
        this.rehydrationTags = rehydrationTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveCreateRequestAttributes logsArchiveCreateRequestAttributes = (LogsArchiveCreateRequestAttributes)o;
        return Objects.equals(this.destination, logsArchiveCreateRequestAttributes.destination) && Objects.equals(this.includeTags, logsArchiveCreateRequestAttributes.includeTags) && Objects.equals(this.name, logsArchiveCreateRequestAttributes.name) && Objects.equals(this.query, logsArchiveCreateRequestAttributes.query) && Objects.equals(this.rehydrationTags, logsArchiveCreateRequestAttributes.rehydrationTags);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.includeTags, this.name, this.query, this.rehydrationTags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveCreateRequestAttributes {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    includeTags: ").append(this.toIndentedString(this.includeTags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rehydrationTags: ").append(this.toIndentedString(this.rehydrationTags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

