/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.MetricTagConfigurationMetricTypes;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing the definition of a metric tag configuration attributes.")
@JsonPropertyOrder(value={"created_at", "include_percentiles", "metric_type", "modified_at", "tags"})
public class MetricTagConfigurationAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_INCLUDE_PERCENTILES = "include_percentiles";
    private Boolean includePercentiles;
    public static final String JSON_PROPERTY_METRIC_TYPE = "metric_type";
    private MetricTagConfigurationMetricTypes metricType = MetricTagConfigurationMetricTypes.GAUGE;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;

    public MetricTagConfigurationAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-03-31T09:48:37.463835Z", value="Timestamp when the tag configuration was created.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public MetricTagConfigurationAttributes includePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Toggle to turn on/off percentile aggregations for distribution metrics. Only present when the `metric_type` is `distribution`.")
    @JsonProperty(value="include_percentiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePercentiles() {
        return this.includePercentiles;
    }

    public void setIncludePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
    }

    public MetricTagConfigurationAttributes metricType(MetricTagConfigurationMetricTypes metricType) {
        this.metricType = metricType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metric_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricTagConfigurationMetricTypes getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricTagConfigurationMetricTypes metricType) {
        this.metricType = metricType;
    }

    public MetricTagConfigurationAttributes modifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-03-31T09:48:37.463835Z", value="Timestamp when the tag configuration was last modified.")
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public MetricTagConfigurationAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricTagConfigurationAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"app\",\"datacenter\"]", value="List of tag keys on which to group.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfigurationAttributes metricTagConfigurationAttributes = (MetricTagConfigurationAttributes)o;
        return Objects.equals(this.createdAt, metricTagConfigurationAttributes.createdAt) && Objects.equals(this.includePercentiles, metricTagConfigurationAttributes.includePercentiles) && Objects.equals((Object)this.metricType, (Object)metricTagConfigurationAttributes.metricType) && Objects.equals(this.modifiedAt, metricTagConfigurationAttributes.modifiedAt) && Objects.equals(this.tags, metricTagConfigurationAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.includePercentiles, this.metricType, this.modifiedAt, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfigurationAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    includePercentiles: ").append(this.toIndentedString(this.includePercentiles)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString((Object)this.metricType)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

