/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Audit logs usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"hour", "lines_indexed"})
public class UsageAuditLogsHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_LINES_INDEXED = "lines_indexed";
    private Long linesIndexed;

    public UsageAuditLogsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageAuditLogsHour linesIndexed(Long linesIndexed) {
        this.linesIndexed = linesIndexed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of audit logs lines indexed during a given hour.")
    @JsonProperty(value="lines_indexed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLinesIndexed() {
        return this.linesIndexed;
    }

    public void setLinesIndexed(Long linesIndexed) {
        this.linesIndexed = linesIndexed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAuditLogsHour usageAuditLogsHour = (UsageAuditLogsHour)o;
        return Objects.equals(this.hour, usageAuditLogsHour.hour) && Objects.equals(this.linesIndexed, usageAuditLogsHour.linesIndexed);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.linesIndexed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAuditLogsHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    linesIndexed: ").append(this.toIndentedString(this.linesIndexed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

