/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Unit;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"unit", "values"})
public class ScalarColumn {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private List<Unit> unit = null;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<Double> values = null;

    public ScalarColumn unit(List<Unit> unit) {
        this.unit = unit;
        for (Unit item : unit) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScalarColumn addUnitItem(Unit unitItem) {
        if (this.unit == null) {
            this.unit = new ArrayList<Unit>();
        }
        this.unit.add(unitItem);
        this.unparsed |= unitItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Unit> getUnit() {
        return this.unit;
    }

    public void setUnit(List<Unit> unit) {
        this.unit = unit;
    }

    public ScalarColumn values(List<Double> values) {
        this.values = values;
        return this;
    }

    public ScalarColumn addValuesItem(Double valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Double>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarColumn scalarColumn = (ScalarColumn)o;
        return Objects.equals(this.unit, scalarColumn.unit) && Objects.equals(this.values, scalarColumn.values);
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScalarColumn {\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

