/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

/**
 * A listing of features that may or not apply to a given {@link ProtocolVersion}.
 */
enum ProtocolFeature {

    /**
     * The capability of updating a prepared statement if the result's metadata changes at runtime (for example, if the
     * query is a {@code SELECT *} and the table is altered).
     */
    PREPARED_METADATA_CHANGES,
    //
    ;

    /**
     * Determines whether or not the input version supports ths feature.
     *
     * @param version the version to test against.
     * @return true if supported, false otherwise.
     */
    boolean isSupportedBy(ProtocolVersion version) {
        switch (this) {
            case PREPARED_METADATA_CHANGES:
                return version == ProtocolVersion.V5;
            default:
                return false;
        }
    }

}
