/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.maven.plugins.annotations.Parameter;

public class LicenseHeader
implements FormatterStepFactory {
    @Parameter
    private String file;
    @Parameter
    private String content;
    @Parameter
    private String delimiter;

    @Override
    public final FormatterStep newFormatterStep(FormatterStepConfig config) {
        String delimiterString;
        String string = delimiterString = this.delimiter != null ? this.delimiter : config.getLicenseHeaderDelimiter();
        if (delimiterString == null) {
            throw new IllegalArgumentException("You need to specify 'delimiter'.");
        }
        if (this.file != null ^ this.content != null) {
            if (this.file != null) {
                File licenseHeaderFile = config.getFileLocator().locateFile(this.file);
                return LicenseHeaderStep.createFromFile((File)licenseHeaderFile, (Charset)config.getEncoding(), (String)delimiterString);
            }
            return LicenseHeaderStep.createFromHeader((String)this.content, (String)delimiterString);
        }
        throw new IllegalArgumentException("Must specify exactly one of 'file' or 'content'.");
    }
}

