/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.ArtifactResolver;
import com.diffplug.spotless.maven.FileLocator;
import com.diffplug.spotless.maven.FormatterConfig;
import com.diffplug.spotless.maven.FormatterFactory;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.maven.GitRatchetMaven;
import com.diffplug.spotless.maven.MavenProvisioner;
import com.diffplug.spotless.maven.antlr4.Antlr4;
import com.diffplug.spotless.maven.cpp.Cpp;
import com.diffplug.spotless.maven.generic.Format;
import com.diffplug.spotless.maven.generic.LicenseHeader;
import com.diffplug.spotless.maven.groovy.Groovy;
import com.diffplug.spotless.maven.java.Java;
import com.diffplug.spotless.maven.kotlin.Kotlin;
import com.diffplug.spotless.maven.scala.Scala;
import com.diffplug.spotless.maven.sql.Sql;
import com.diffplug.spotless.maven.typescript.Typescript;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.MatchPatterns;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractSpotlessMojo
extends AbstractMojo {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_LINE_ENDINGS = "GIT_ATTRIBUTES";
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResourceManager resourceManager;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", required=true, readonly=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDir;
    @Parameter(defaultValue="UTF-8")
    private String encoding;
    @Parameter(defaultValue="GIT_ATTRIBUTES")
    private LineEnding lineEndings;
    @Parameter
    private String ratchetFrom;
    @Parameter
    private LicenseHeader licenseHeader;
    @Parameter
    private List<Format> formats = Collections.emptyList();
    @Parameter
    private Groovy groovy;
    @Parameter
    private Java java;
    @Parameter
    private Scala scala;
    @Parameter
    private Kotlin kotlin;
    @Parameter
    private Cpp cpp;
    @Parameter
    private Typescript typescript;
    @Parameter
    private Antlr4 antlr4;
    @Parameter
    private Sql sql;
    @Parameter(property="spotlessFiles")
    private String filePatterns;
    @Parameter(property="spotlessSetLicenseHeaderYearsFromGitHistory")
    private String setLicenseHeaderYearsFromGitHistory;

    protected abstract void process(Iterable<File> var1, Formatter var2) throws MojoExecutionException;

    public final void execute() throws MojoExecutionException {
        List<FormatterFactory> formatterFactories = this.getFormatterFactories();
        for (FormatterFactory formatterFactory : formatterFactories) {
            this.execute(formatterFactory);
        }
    }

    private void execute(FormatterFactory formatterFactory) throws MojoExecutionException {
        FormatterConfig config = this.getFormatterConfig();
        List<File> files = this.collectFiles(formatterFactory, config);
        try (Formatter formatter = formatterFactory.newFormatter(files, config);){
            this.process(files, formatter);
        }
    }

    private List<File> collectFiles(FormatterFactory formatterFactory, FormatterConfig config) throws MojoExecutionException {
        Optional<String> ratchetFrom = formatterFactory.ratchetFrom(config);
        try {
            List<File> files = ratchetFrom.isPresent() ? this.collectFilesFromGit(formatterFactory, ratchetFrom.get()) : this.collectFilesFromFormatterFactory(formatterFactory);
            if (this.filePatterns == null || this.filePatterns.isEmpty()) {
                return files;
            }
            String[] includePatterns = this.filePatterns.split(",");
            List compiledIncludePatterns = Arrays.stream(includePatterns).map(Pattern::compile).collect(Collectors.toList());
            Predicate<File> shouldInclude = file -> compiledIncludePatterns.stream().anyMatch(filePattern -> filePattern.matcher(file.getAbsolutePath()).matches());
            return files.stream().filter(shouldInclude).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan file tree rooted at " + this.baseDir, (Exception)e);
        }
    }

    private List<File> collectFilesFromGit(FormatterFactory formatterFactory, String ratchetFrom) throws MojoExecutionException {
        Iterable<String> dirtyFiles;
        MatchPatterns includePatterns = MatchPatterns.from(this.withNormalizedFileSeparators(this.getIncludes(formatterFactory)));
        MatchPatterns excludePatterns = MatchPatterns.from(this.withNormalizedFileSeparators(this.getExcludes(formatterFactory)));
        try {
            dirtyFiles = GitRatchetMaven.instance().getDirtyFiles(this.baseDir, ratchetFrom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan file tree rooted at " + this.baseDir, (Exception)e);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String file : this.withNormalizedFileSeparators(dirtyFiles)) {
            if (!includePatterns.matches(file, true) || excludePatterns.matches(file, true)) continue;
            result.add(new File(this.baseDir.getPath(), file));
        }
        return result;
    }

    private List<File> collectFilesFromFormatterFactory(FormatterFactory formatterFactory) throws MojoExecutionException, IOException {
        String includesString = String.join((CharSequence)",", this.getIncludes(formatterFactory));
        String excludesString = String.join((CharSequence)",", this.getExcludes(formatterFactory));
        return FileUtils.getFiles((File)this.baseDir, (String)includesString, (String)excludesString);
    }

    private Iterable<String> withNormalizedFileSeparators(Iterable<String> patterns) {
        return StreamSupport.stream(patterns.spliterator(), true).map(pattern -> pattern.replace('/', File.separatorChar)).map(pattern -> pattern.replace('\\', File.separatorChar)).collect(Collectors.toSet());
    }

    private static String withTrailingSeparator(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    private Set<String> getIncludes(FormatterFactory formatterFactory) throws MojoExecutionException {
        Set<String> includes;
        Set<String> configuredIncludes = formatterFactory.includes();
        Set<String> set = includes = configuredIncludes.isEmpty() ? formatterFactory.defaultIncludes() : configuredIncludes;
        if (includes.isEmpty()) {
            throw new MojoExecutionException("You must specify some files to include, such as '<includes><include>src/**</include></includes>'");
        }
        return includes;
    }

    private Set<String> getExcludes(FormatterFactory formatterFactory) {
        Set<String> configuredExcludes = formatterFactory.excludes();
        HashSet<String> excludes = new HashSet<String>(FileUtils.getDefaultExcludesAsList());
        excludes.add(AbstractSpotlessMojo.withTrailingSeparator(this.buildDir.toString()));
        excludes.addAll(configuredExcludes);
        return excludes;
    }

    private FormatterConfig getFormatterConfig() {
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.repositorySystemSession, this.repositories, this.getLog());
        Provisioner provisioner = MavenProvisioner.create(resolver);
        List<FormatterStepFactory> formatterStepFactories = this.getFormatterStepFactories();
        FileLocator fileLocator = this.getFileLocator();
        return new FormatterConfig(this.baseDir, this.encoding, this.lineEndings, Optional.ofNullable(this.ratchetFrom), provisioner, fileLocator, formatterStepFactories, Optional.ofNullable(this.setLicenseHeaderYearsFromGitHistory));
    }

    private FileLocator getFileLocator() {
        this.resourceManager.addSearchPath("file", this.baseDir.getAbsolutePath());
        this.resourceManager.addSearchPath("url", "");
        this.resourceManager.setOutputDirectory(this.buildDir);
        return new FileLocator(this.resourceManager, this.baseDir, this.buildDir);
    }

    private List<FormatterFactory> getFormatterFactories() {
        return Stream.concat(this.formats.stream(), Stream.of(this.groovy, this.java, this.scala, this.kotlin, this.cpp, this.typescript, this.antlr4, this.sql)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<FormatterStepFactory> getFormatterStepFactories() {
        return Stream.of(this.licenseHeader).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

