/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.extra.integration.DiffMessageFormatter;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SpotlessCheckMojo
extends AbstractSpotlessMojo {
    @Override
    protected void process(Iterable<File> files, Formatter formatter, UpToDateChecker upToDateChecker) throws MojoExecutionException {
        ArrayList<File> problemFiles = new ArrayList<File>();
        for (File file : files) {
            if (upToDateChecker.isUpToDate(file.toPath())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Spotless will not check an up-to-date file: " + file));
                continue;
            }
            try {
                PaddedCell.DirtyState dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file);
                if (!dirtyState.isClean() && !dirtyState.didNotConverge()) {
                    problemFiles.add(file);
                    continue;
                }
                upToDateChecker.setUpToDate(file.toPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to format file " + file, (Exception)e);
            }
        }
        if (!problemFiles.isEmpty()) {
            throw new MojoExecutionException(DiffMessageFormatter.builder().runToFix("Run 'mvn spotless:apply' to fix these violations.").formatter(formatter).problemFiles(problemFiles).getMessage());
        }
    }
}

