/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.javascript;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.npm.AbstractNpmFormatterStepFactory;
import com.diffplug.spotless.npm.EslintConfig;
import com.diffplug.spotless.npm.EslintFormatterStep;
import com.diffplug.spotless.npm.NpmPathResolver;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractEslint
extends AbstractNpmFormatterStepFactory {
    public static final String ERROR_MESSAGE_ONLY_ONE_CONFIG = "must specify exactly one eslintVersion, devDependencies or devDependencyProperties";
    @Parameter
    protected String configFile;
    @Parameter
    protected String configJs;
    @Parameter
    protected String eslintVersion;
    @Parameter
    protected Map<String, String> devDependencies;
    @Parameter
    protected Properties devDependencyProperties;

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        if (this.moreThanOneNonNull(this.eslintVersion, this.devDependencies, this.devDependencyProperties)) {
            throw AbstractEslint.onlyOneConfig();
        }
        TreeMap<String, String> devDependencies = new TreeMap<String, String>();
        if (this.devDependencies != null) {
            devDependencies.putAll(this.devDependencies);
        } else if (this.devDependencyProperties != null) {
            devDependencies.putAll(this.propertiesAsMap(this.devDependencyProperties));
        } else {
            Map<String, String> defaultDependencies = this.createDefaultDependencies();
            devDependencies.putAll(defaultDependencies);
        }
        File buildDir = this.buildDir(stepConfig);
        File baseDir = this.baseDir(stepConfig);
        NpmPathResolver npmPathResolver = this.npmPathResolver(stepConfig);
        return EslintFormatterStep.create(devDependencies, (Provisioner)stepConfig.getProvisioner(), (File)baseDir, (File)buildDir, (NpmPathResolver)npmPathResolver, (EslintConfig)this.eslintConfig(stepConfig));
    }

    private static IllegalArgumentException onlyOneConfig() {
        return new IllegalArgumentException(ERROR_MESSAGE_ONLY_ONE_CONFIG);
    }

    protected abstract EslintConfig eslintConfig(FormatterStepConfig var1);

    protected abstract Map<String, String> createDefaultDependencies();
}

