/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.json;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.json.JacksonJsonConfig;
import com.diffplug.spotless.json.JacksonJsonStep;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class JacksonJson
implements FormatterStepFactory {
    @Parameter
    private String version = JacksonJsonStep.defaultVersion();
    @Parameter
    private boolean spaceBeforeSeparator = new JacksonJsonConfig().isSpaceBeforeSeparator();
    @Parameter
    private Map<String, Boolean> features = Collections.emptyMap();
    @Parameter
    private Map<String, Boolean> jsonFeatures = Collections.emptyMap();

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        JacksonJsonConfig jacksonConfig = new JacksonJsonConfig();
        jacksonConfig.appendFeatureToToggle(this.features);
        jacksonConfig.appendJsonFeatureToToggle(this.jsonFeatures);
        jacksonConfig.setSpaceBeforeSeparator(this.spaceBeforeSeparator);
        return JacksonJsonStep.create((JacksonJsonConfig)jacksonConfig, (String)this.version, (Provisioner)stepConfig.getProvisioner());
    }
}

