/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.generic.EndWithNewlineStep;
import com.diffplug.spotless.generic.IndentStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.generic.ReplaceRegexStep;
import com.diffplug.spotless.generic.ReplaceStep;
import com.diffplug.spotless.generic.TrimTrailingWhitespaceStep;
import groovy.lang.Closure;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;

public class FormatExtension {
    final SpotlessExtension root;
    boolean paddedCell = false;
    LineEnding lineEndings;
    Charset encoding;
    protected FileCollection target;
    protected List<FormatterStep> steps = new ArrayList<FormatterStep>();
    private Serializable globalState = new NeverUpToDateBetweenRuns();

    public FormatExtension(SpotlessExtension root) {
        this.root = root;
    }

    private String formatName() {
        for (Map.Entry<String, FormatExtension> entry : this.root.formats.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("This format is not contained by any SpotlessExtension.");
    }

    public void paddedCell() {
        this.paddedCell(true);
    }

    public void paddedCell(boolean paddedCell) {
        this.paddedCell = paddedCell;
    }

    public LineEnding getLineEndings() {
        return this.lineEndings == null ? this.root.getLineEndings() : this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = lineEndings;
    }

    public Charset getEncoding() {
        return this.encoding == null ? this.root.getEncoding() : this.encoding;
    }

    public void setEncoding(String name) {
        this.setEncoding(Charset.forName(name));
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void target(Object ... targets) {
        if (targets.length == 0) {
            this.target = this.getProject().files(new Object[0]);
        } else if (targets.length == 1) {
            this.target = this.parseTarget(targets[0]);
        } else if (Stream.of(targets).allMatch(o -> o instanceof String)) {
            this.target = this.parseTarget(Arrays.asList(targets));
        } else {
            UnionFileCollection union = new UnionFileCollection(new FileCollection[0]);
            for (Object target : targets) {
                union.add(this.parseTarget(target));
            }
            this.target = union;
        }
    }

    protected FileCollection parseTarget(Object target) {
        if (target instanceof FileCollection) {
            return (FileCollection)target;
        }
        if (target instanceof String || target instanceof List && ((List)target).stream().allMatch(o -> o instanceof String)) {
            File dir = this.getProject().getProjectDir();
            ArrayList<String> excludes = new ArrayList<String>();
            excludes.add(".git");
            if (this.getProject() == this.getProject().getRootProject()) {
                excludes.add(".gradle");
            }
            excludes.add(FormatExtension.relativize(dir, this.getProject().getBuildDir()));
            for (Project subproject : this.getProject().getSubprojects()) {
                excludes.add(FormatExtension.relativize(dir, subproject.getBuildDir()));
            }
            if (target instanceof String) {
                return (FileCollection)this.getProject().fileTree((Object)dir).include(new String[]{(String)target}).exclude(excludes);
            }
            return (FileCollection)this.getProject().fileTree((Object)dir).include((Iterable)((List)target)).exclude(excludes);
        }
        return this.getProject().files(new Object[]{target});
    }

    static String relativize(File root, File dest) {
        String rootPath = root.getAbsolutePath();
        String destPath = dest.getAbsolutePath();
        if (!destPath.startsWith(rootPath)) {
            throw new IllegalArgumentException(dest + " is not a child of " + root);
        }
        return destPath.substring(rootPath.length());
    }

    public void addStep(FormatterStep newStep) {
        for (FormatterStep step : this.steps) {
            if (!newStep.getName().equals(step.getName())) continue;
            throw new GradleException("Multiple steps with name '" + newStep.getName() + "' for spotless format '" + this.formatName() + "'");
        }
        this.steps.add(newStep);
    }

    public void clearSteps() {
        this.steps.clear();
    }

    public void bumpThisNumberIfACustomStepChanges(int number) {
        this.globalState = Integer.valueOf(number);
    }

    public void customLazy(String name, ThrowingEx.Supplier<FormatterFunc> formatterSupplier) {
        this.addStep(FormatterStep.createLazy((String)name, () -> this.globalState, unusedState -> (FormatterFunc)formatterSupplier.get()));
    }

    public void customLazyGroovy(String name, ThrowingEx.Supplier<Closure<String>> formatterSupplier) {
        this.customLazy(name, (ThrowingEx.Supplier<FormatterFunc>)((ThrowingEx.Supplier)() -> arg_0 -> ((Closure)((Closure)formatterSupplier.get())).call(arg_0)));
    }

    public void custom(String name, Closure<String> formatter) {
        this.custom(name, arg_0 -> formatter.call(arg_0));
    }

    public void custom(String name, FormatterFunc formatter) {
        this.customLazy(name, (ThrowingEx.Supplier<FormatterFunc>)((ThrowingEx.Supplier)() -> formatter));
    }

    public void replace(String name, CharSequence original, CharSequence after) {
        this.addStep(ReplaceStep.create((String)name, (CharSequence)original, (CharSequence)after));
    }

    public void replaceRegex(String name, String regex, String replacement) {
        this.addStep(ReplaceRegexStep.create((String)name, (String)regex, (String)replacement));
    }

    public void trimTrailingWhitespace() {
        this.addStep(TrimTrailingWhitespaceStep.create());
    }

    public void endWithNewline() {
        this.addStep(EndWithNewlineStep.create());
    }

    public void indentWithSpaces(int numSpacesPerTab) {
        this.addStep(IndentStep.Type.SPACE.create(numSpacesPerTab));
    }

    public void indentWithSpaces() {
        this.indentWithSpaces(4);
    }

    public void indentWithTabs(int tabToSpaces) {
        this.addStep(IndentStep.Type.TAB.create(tabToSpaces));
    }

    public void indentWithTabs() {
        this.indentWithTabs(4);
    }

    public void licenseHeader(String licenseHeader, String delimiter) {
        this.addStep(LicenseHeaderStep.createFromHeader((String)licenseHeader, (String)delimiter));
    }

    public void licenseHeaderFile(Object licenseHeaderFile, String delimiter) {
        this.addStep(LicenseHeaderStep.createFromFile((File)this.getProject().file(licenseHeaderFile), (Charset)this.getEncoding(), (String)delimiter));
    }

    protected void setupTask(SpotlessTask task) {
        task.setPaddedCell(this.paddedCell);
        task.setEncoding(this.getEncoding().name());
        task.setTarget((Iterable<File>)this.target);
        task.setSteps(this.steps);
        task.setLineEndingsPolicy(this.getLineEndings().createPolicy(this.getProject().getProjectDir(), () -> spotlessTask.target));
    }

    protected Project getProject() {
        return this.root.project;
    }

    static class NeverUpToDateBetweenRuns
    extends LazyForwardingEquality<Integer> {
        private static final long serialVersionUID = 1L;
        private static final Random RANDOM = new Random();

        NeverUpToDateBetweenRuns() {
        }

        protected Integer calculateState() throws Exception {
            return RANDOM.nextInt();
        }
    }
}

