/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.io.Files;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.markdown.FreshMarkStep;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;

public class FreshMarkExtension
extends FormatExtension {
    static final String NAME = "freshmark";
    public List<Action<Map<String, Object>>> propertyActions = new ArrayList<Action<Map<String, Object>>>();

    public FreshMarkExtension(SpotlessExtension root) {
        super(root);
        this.addStep(FreshMarkStep.create(() -> {
            HashMap map = new HashMap();
            for (Action<Map<String, Object>> action : this.propertyActions) {
                action.execute(map);
            }
            return map;
        }, (Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    public void properties(Action<Map<String, Object>> action) {
        this.propertyActions.add(action);
    }

    public void propertiesFile(Object file) {
        this.propertyActions.add((Action<Map<String, Object>>)((Action)map -> {
            File propFile = this.getProject().file(file);
            try (InputStream input = Files.asByteSource((File)propFile).openBufferedStream();){
                Properties props = new Properties();
                props.load(input);
                for (String key : props.stringPropertyNames()) {
                    map.put(key, props.getProperty(key));
                }
            }
            catch (IOException e) {
                throw Errors.asRuntime((Throwable)e);
            }
        }));
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget("**/*.md");
        }
        super.setupTask(task);
    }
}

