/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializableFileFilter;
import com.diffplug.spotless.extra.java.EclipseFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.GoogleJavaFormatStep;
import com.diffplug.spotless.java.ImportOrderStep;
import com.diffplug.spotless.java.RemoveUnusedImportsStep;
import java.io.File;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class JavaExtension
extends FormatExtension {
    static final String NAME = "java";
    private static final String LICENSE_HEADER_DELIMITER = "package ";

    public JavaExtension(SpotlessExtension rootExtension) {
        super(rootExtension);
    }

    public void licenseHeader(String licenseHeader) {
        this.licenseHeader(licenseHeader, LICENSE_HEADER_DELIMITER);
    }

    public void licenseHeaderFile(Object licenseHeaderFile) {
        this.licenseHeaderFile(licenseHeaderFile, LICENSE_HEADER_DELIMITER);
    }

    public void importOrder(List<String> importOrder) {
        this.addStep(ImportOrderStep.createFromOrder(importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        this.addStep(ImportOrderStep.createFromFile((File)this.getProject().file(importOrderFile)));
    }

    public void eclipseFormatFile(Object eclipseFormatFile) {
        this.eclipseFormatFile(EclipseFormatterStep.defaultVersion(), eclipseFormatFile);
    }

    public void eclipseFormatFile(String eclipseVersion, Object eclipseFormatFile) {
        this.addStep(EclipseFormatterStep.create((String)eclipseVersion, (File)this.getProject().file(eclipseFormatFile), (Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    public void removeUnusedImports() {
        this.addStep(RemoveUnusedImportsStep.create((Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    public void googleJavaFormat() {
        this.googleJavaFormat(GoogleJavaFormatStep.defaultVersion());
    }

    public void googleJavaFormat(String version) {
        this.addStep(GoogleJavaFormatStep.create((String)version, (Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPlugin == null) {
                throw new GradleException("You must apply the java plugin before the spotless plugin if you are using the java extension.");
            }
            UnionFileCollection union = new UnionFileCollection(new FileCollection[0]);
            for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                union.add((FileCollection)sourceSet.getAllJava());
            }
            this.target = union;
        }
        this.steps.replaceAll(step -> {
            if (LicenseHeaderStep.name().equals(step.getName())) {
                return step.filterByFile(SerializableFileFilter.skipFilesNamed((String)"package-info.java"));
            }
            return step;
        });
        super.setupTask(task);
    }
}

