/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.FreshMarkExtension;
import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.spotless.LineEnding;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class SpotlessExtension {
    final Project project;
    LineEnding lineEndings = LineEnding.GIT_ATTRIBUTES;
    Charset encoding = StandardCharsets.UTF_8;
    Map<String, FormatExtension> formats = new LinkedHashMap<String, FormatExtension>();

    public SpotlessExtension(Project project) {
        this.project = project;
    }

    public LineEnding getLineEndings() {
        return this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = lineEndings;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String name) {
        this.setEncoding(Charset.forName(name));
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void java(Action<JavaExtension> closure) {
        this.configure("java", JavaExtension.class, closure);
    }

    public void freshmark(Action<FreshMarkExtension> closure) {
        this.configure("freshmark", FreshMarkExtension.class, closure);
    }

    public void format(String name, Action<FormatExtension> closure) {
        this.configure(name, FormatExtension.class, closure);
    }

    public void removeFormat(String name) {
        FormatExtension toRemove = this.formats.remove(name);
        if (toRemove == null) {
            this.project.getLogger().warn("Called removeFormat('" + name + "') but there was no such format.");
        }
    }

    private <T extends FormatExtension> void configure(String name, Class<T> clazz, Action<T> configure) {
        T value = this.maybeCreate(name, clazz);
        configure.execute(value);
    }

    private <T extends FormatExtension> T maybeCreate(String name, Class<T> clazz) {
        FormatExtension existing = this.formats.get(name);
        if (existing != null) {
            if (!existing.getClass().equals(clazz)) {
                throw new GradleException("Tried to add format named '" + name + "'" + " of type " + clazz + " but one has already been created of type " + existing.getClass());
            }
            return (T)existing;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(SpotlessExtension.class);
            FormatExtension newlyCreated = (FormatExtension)constructor.newInstance(this);
            this.formats.put(name, newlyCreated);
            return (T)newlyCreated;
        }
        catch (NoSuchMethodException e) {
            throw new GradleException("Must have a constructor " + clazz.getSimpleName() + "(SpotlessExtension root)", (Throwable)e);
        }
        catch (Exception e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }
}

