/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.Provisioner;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class GradleProvisioner {
    private static final Logger logger = Logger.getLogger(GradleProvisioner.class.getName());

    private GradleProvisioner() {
    }

    public static Provisioner fromProject(Project project) {
        Objects.requireNonNull(project);
        return mavenCoords -> {
            try {
                Dependency[] deps = (Dependency[])mavenCoords.stream().map(arg_0 -> ((DependencyHandler)project.getBuildscript().getDependencies()).create(arg_0)).toArray(Dependency[]::new);
                Configuration config = project.getBuildscript().getConfigurations().detachedConfiguration(deps);
                config.setDescription(mavenCoords.toString());
                return config.resolve();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "You probably need to add a repository containing the '" + mavenCoords + "' artifact, e.g.: 'buildscript { repositories { mavenCentral() }}'", e);
                throw e;
            }
        };
    }
}

