/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.KtLintStep;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class KotlinExtension
extends FormatExtension {
    static final String NAME = "kotin";

    public KotlinExtension(SpotlessExtension rootExtension) {
        super(rootExtension);
    }

    public void licenseHeader(String licenseHeader) {
        this.licenseHeader(licenseHeader, "package ");
    }

    public void licenseHeaderFile(Object licenseHeaderFile) {
        this.licenseHeaderFile(licenseHeaderFile, "package ");
    }

    public void ktlint(String version) {
        Objects.requireNonNull(version);
        this.addStep(KtLintStep.create((String)version, (Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    public void ktlint() {
        this.ktlint(KtLintStep.defaultVersion());
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPlugin == null) {
                throw new GradleException("You must either specify 'target' manually or apply a kotlin plugin.");
            }
            UnionFileCollection union = new UnionFileCollection(new FileCollection[0]);
            for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                union.add(sourceSet.getAllSource().filter(file -> {
                    String name = file.getName();
                    return name.endsWith(".kt") || name.endsWith(".kts");
                }));
            }
            this.target = union;
        }
        super.setupTask(task);
    }
}

