/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializableFileFilter;
import com.diffplug.spotless.extra.groovy.GrEclipseFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.ImportOrderStep;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;

public class GroovyExtension
extends FormatExtension {
    static final String NAME = "groovy";
    boolean excludeJava = false;

    public GroovyExtension(SpotlessExtension rootExtension) {
        super(rootExtension);
    }

    public void excludeJava() {
        this.excludeJava(true);
    }

    public void excludeJava(boolean excludeJava) {
        this.excludeJava = excludeJava;
    }

    public void licenseHeader(String licenseHeader) {
        this.licenseHeader(licenseHeader, "package ");
    }

    public void licenseHeaderFile(Object licenseHeaderFile) {
        this.licenseHeaderFile(licenseHeaderFile, "package ");
    }

    @Deprecated
    public void importOrder(List<String> importOrder) {
        this.getProject().getLogger().warn(StringPrinter.buildStringFromLines((String[])new String[]{"'importOrder([x, y, z])' is deprecated.", "Use 'importOrder x, y, z' instead.", "For details see https://github.com/diffplug/spotless/tree/master/plugin-gradle#applying-to-java-source"}));
        this.addStep(ImportOrderStep.createFromOrder(importOrder));
    }

    public void importOrder(String ... importOrder) {
        this.addStep(ImportOrderStep.createFromOrder((String[])importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        this.addStep(ImportOrderStep.createFromFile((File)this.getProject().file(importOrderFile)));
    }

    public GrEclipseConfig greclipse() {
        return this.greclipse(GrEclipseFormatterStep.defaultVersion());
    }

    public GrEclipseConfig greclipse(String version) {
        return new GrEclipseConfig(version, this);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention convention = (JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class);
            if (convention == null || !this.getProject().getPlugins().hasPlugin(GroovyBasePlugin.class)) {
                throw new GradleException("You must apply the groovy plugin before the spotless plugin if you are using the groovy extension.");
            }
            UnionFileCollection union = new UnionFileCollection(new FileCollection[0]);
            for (SourceSet sourceSet : convention.getSourceSets()) {
                GroovySourceSet groovySourceSet = (GroovySourceSet)new DslObject((Object)sourceSet).getConvention().getPlugin(GroovySourceSet.class);
                if (this.excludeJava) {
                    union.add((FileCollection)groovySourceSet.getAllGroovy());
                    continue;
                }
                union.add((FileCollection)groovySourceSet.getGroovy());
            }
            this.target = union;
        } else if (this.excludeJava) {
            throw new IllegalArgumentException("'excludeJava' is not supported in combination with a custom 'target'.");
        }
        this.steps.replaceAll(step -> {
            if (LicenseHeaderStep.name().equals(step.getName())) {
                return step.filterByFile(SerializableFileFilter.skipFilesNamed((String[])new String[]{"package-info.java", "package-info.groovy"}));
            }
            return step;
        });
        super.setupTask(task);
    }

    public static class GrEclipseConfig {
        final String version;
        Object[] configFiles;
        final FormatExtension extension;

        GrEclipseConfig(String version, FormatExtension extension) {
            this.extension = extension;
            this.configFiles = new Object[0];
            this.version = Objects.requireNonNull(version);
            extension.addStep(this.createStep());
        }

        public void configFile(Object ... configFiles) {
            this.configFiles = PluginGradlePreconditions.requireElementsNonNull(configFiles);
            this.extension.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            Project project = this.extension.getProject();
            return GrEclipseFormatterStep.create((String)this.version, (Iterable)project.files(this.configFiles).getFiles(), (Provisioner)GradleProvisioner.fromProject(project));
        }
    }
}

