/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.KtLintStep;
import java.util.Objects;

public class KotlinGradleExtension
extends FormatExtension {
    private static final String GRADLE_KOTLIN_DSL_FILE_EXTENSION = "*.gradle.kts";
    static final String NAME = "kotlinGradle";

    public KotlinGradleExtension(SpotlessExtension rootExtension) {
        super(rootExtension);
    }

    public void ktlint(String version) {
        Objects.requireNonNull(version, "version");
        this.addStep(KtLintStep.create((String)version, (Provisioner)GradleProvisioner.fromProject(this.getProject())));
    }

    public void ktlint() {
        this.ktlint(KtLintStep.defaultVersion());
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget(GRADLE_KOTLIN_DSL_FILE_EXTENSION);
        }
        super.setupTask(task);
    }
}

