/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.DiffMessageFormatter;
import com.diffplug.gradle.spotless.PaddedCellGradle;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.PaddedCellBulk;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class SpotlessTask
extends DefaultTask {
    @Input
    protected String encoding = "UTF-8";
    @Input
    protected LineEnding.Policy lineEndingsPolicy = LineEnding.UNIX.createPolicy();
    @Input
    protected boolean paddedCell = false;
    @Input
    protected FormatExceptionPolicy exceptionPolicy = new FormatExceptionPolicyStrict();
    @InputFiles
    @SkipWhenEmpty
    protected Iterable<File> target;
    @Input
    protected List<FormatterStep> steps = new ArrayList<FormatterStep>();
    private boolean check = false;
    private boolean apply = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Objects.requireNonNull(encoding);
    }

    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public void setLineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
        this.lineEndingsPolicy = Objects.requireNonNull(lineEndingsPolicy);
    }

    public boolean isPaddedCell() {
        return this.paddedCell;
    }

    public void setPaddedCell(boolean paddedCell) {
        this.paddedCell = paddedCell;
    }

    public void setExceptionPolicy(FormatExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = Objects.requireNonNull(exceptionPolicy);
    }

    public FormatExceptionPolicy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    public Iterable<File> getTarget() {
        return this.target;
    }

    public void setTarget(Iterable<File> target) {
        this.target = PluginGradlePreconditions.requireElementsNonNull(target);
    }

    public List<FormatterStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void setSteps(List<FormatterStep> steps) {
        this.steps = PluginGradlePreconditions.requireElementsNonNull(steps);
    }

    public boolean addStep(FormatterStep step) {
        return this.steps.add(Objects.requireNonNull(step));
    }

    public void setCheck() {
        this.check = true;
    }

    public void setApply() {
        this.apply = true;
    }

    String formatName() {
        String name = this.getName();
        if (name.startsWith("spotless")) {
            return name.substring("spotless".length()).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    @TaskAction
    public void performAction(IncrementalTaskInputs inputs) throws Exception {
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> toFormat'");
        }
        if (!this.check && !this.apply) {
            throw new GradleException("Don't call " + this.getName() + " directly, call " + this.getName() + "Check" + " or " + this.getName() + "Apply");
        }
        Formatter formatter = Formatter.builder().lineEndingsPolicy(this.lineEndingsPolicy).encoding(Charset.forName(this.encoding)).rootDir(this.getProject().getProjectDir().toPath()).steps(this.steps).exceptionPolicy(this.exceptionPolicy).build();
        ArrayList<File> outOfDate = new ArrayList<File>();
        inputs.outOfDate(inputDetails -> {
            File file = inputDetails.getFile();
            if (file.isFile()) {
                outOfDate.add(file);
            }
        });
        if (this.apply) {
            this.apply(formatter, outOfDate);
        }
        if (this.check) {
            this.check(formatter, outOfDate);
        }
    }

    private void apply(Formatter formatter, List<File> outOfDate) throws Exception {
        if (this.isPaddedCell()) {
            for (File file : outOfDate) {
                this.getLogger().debug("Applying format to " + file);
                PaddedCellBulk.apply((Formatter)formatter, (File)file);
            }
        } else {
            boolean anyMisbehave = false;
            for (File file : outOfDate) {
                String onceMore;
                this.getLogger().debug("Applying format to " + file);
                String unixResultIfDirty = formatter.applyToAndReturnResultIfDirty(file);
                if (anyMisbehave || unixResultIfDirty == null || (onceMore = formatter.compute(unixResultIfDirty, file)).equals(unixResultIfDirty)) continue;
                PaddedCell result = PaddedCell.check((Formatter)formatter, (File)file, (String)onceMore);
                if (result.type() == PaddedCell.Type.CONVERGE) {
                    String finalResult = formatter.computeLineEndings(result.canonical(), file);
                    Files.write(file.toPath(), finalResult.getBytes(formatter.getEncoding()), StandardOpenOption.TRUNCATE_EXISTING);
                    continue;
                }
                anyMisbehave = true;
            }
            if (anyMisbehave) {
                throw PaddedCellGradle.youShouldTurnOnPaddedCell(this);
            }
        }
    }

    private void check(Formatter formatter, List<File> outOfDate) throws Exception {
        ArrayList<File> problemFiles = new ArrayList<File>();
        for (File file : outOfDate) {
            this.getLogger().debug("Checking format on " + file);
            if (formatter.isClean(file)) continue;
            problemFiles.add(file);
        }
        if (this.paddedCell) {
            PaddedCellGradle.check(this, formatter, problemFiles);
        } else if (!problemFiles.isEmpty()) {
            if (PaddedCellBulk.anyMisbehave((Formatter)formatter, problemFiles)) {
                throw PaddedCellGradle.youShouldTurnOnPaddedCell(this);
            }
            throw this.formatViolationsFor(formatter, problemFiles);
        }
    }

    GradleException formatViolationsFor(Formatter formatter, List<File> problemFiles) throws IOException {
        return new GradleException(DiffMessageFormatter.messageFor(this, formatter, problemFiles));
    }
}

