/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.collect.HashBasedTable;
import com.diffplug.common.collect.Table;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.gradle.api.Project;

class GitRatchet
implements AutoCloseable {
    private static final int TREE = 0;
    private static final int INDEX = 1;
    private static final int WORKDIR = 2;
    TreeMap<Project, Repository> gitRoots = new TreeMap();
    Table<Repository, String, ObjectId> shaCache = HashBasedTable.create();

    GitRatchet() {
    }

    private static GitRatchet instance(Project project) {
        return ((SpotlessPlugin)project.getPlugins().getPlugin(SpotlessPlugin.class)).spotlessExtension.registerDependenciesTask.gitRatchet;
    }

    public static boolean isClean(Project project, ObjectId treeSha, File file) throws IOException {
        GitRatchet instance = GitRatchet.instance(project);
        Repository repo = instance.repositoryFor(project);
        String path = repo.getWorkTree().toPath().relativize(file.toPath()).toString();
        DirCache dirCache = repo.readDirCache();
        try (TreeWalk treeWalk = new TreeWalk(repo);){
            boolean hasDirCache;
            treeWalk.setRecursive(true);
            treeWalk.addTree((AnyObjectId)treeSha);
            treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(dirCache));
            treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repo));
            treeWalk.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)new IndexDiffFilter(1, 2)));
            if (!treeWalk.next()) {
                boolean bl = true;
                return bl;
            }
            AbstractTreeIterator treeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
            DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
            WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)treeWalk.getTree(2, WorkingTreeIterator.class);
            boolean hasTree = treeIterator != null;
            boolean bl = hasDirCache = dirCacheIterator != null;
            if (!hasTree) {
                boolean bl2 = false;
                return bl2;
            }
            if (hasDirCache) {
                boolean indexEqualsWC;
                boolean treeEqualsIndex = treeIterator.idEqual((AbstractTreeIterator)dirCacheIterator) && treeIterator.getEntryRawMode() == dirCacheIterator.getEntryRawMode();
                boolean bl3 = indexEqualsWC = !workingTreeIterator.isModified(dirCacheIterator.getDirCacheEntry(), true, treeWalk.getObjectReader());
                if (treeEqualsIndex != indexEqualsWC) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (treeEqualsIndex) {
                    throw new IllegalStateException("Index status for " + file + " against treeSha " + treeSha + " is invalid.");
                }
                boolean bl5 = GitRatchet.worktreeIsCleanCheckout(treeWalk);
                return bl5;
            }
            boolean bl6 = GitRatchet.worktreeIsCleanCheckout(treeWalk);
            return bl6;
        }
    }

    private static boolean worktreeIsCleanCheckout(TreeWalk treeWalk) {
        return treeWalk.idEqual(0, 2);
    }

    private Repository repositoryFor(Project project) throws IOException {
        Repository repo = this.gitRoots.get(project);
        if (repo == null) {
            if (GitRatchet.isGitRoot(project.getProjectDir())) {
                repo = GitRatchet.createRepo(project.getProjectDir());
            } else {
                Project parentProj = project.getParent();
                if (parentProj == null) {
                    repo = GitRatchet.traverseParentsUntil(project.getProjectDir().getParentFile(), null);
                    if (repo == null) {
                        throw new IllegalArgumentException("Cannot find git repository in any parent directory");
                    }
                } else {
                    repo = GitRatchet.traverseParentsUntil(project.getProjectDir().getParentFile(), parentProj.getProjectDir());
                    if (repo == null) {
                        repo = this.repositoryFor(parentProj);
                    }
                }
            }
            this.gitRoots.put(project, repo);
        }
        return repo;
    }

    @Nullable
    private static Repository traverseParentsUntil(File startWith, File file) throws IOException {
        do {
            if (!GitRatchet.isGitRoot(startWith)) continue;
            return GitRatchet.createRepo(startWith);
        } while (!Objects.equals(startWith = startWith.getParentFile(), file));
        return null;
    }

    private static boolean isGitRoot(File dir) {
        File dotGit = new File(dir, ".git");
        return dotGit.isDirectory() && RepositoryCache.FileKey.isGitRepository((File)dotGit, (FS)FS.DETECTED);
    }

    static Repository createRepo(File dir) throws IOException {
        return FileRepositoryBuilder.create((File)new File(dir, ".git"));
    }

    public static ObjectId treeShaOf(Project project, String reference) {
        GitRatchet instance;
        GitRatchet gitRatchet = instance = GitRatchet.instance(project);
        synchronized (gitRatchet) {
            try {
                Repository repo = instance.repositoryFor(project);
                ObjectId treeSha = (ObjectId)instance.shaCache.get((Object)repo, (Object)reference);
                if (treeSha == null) {
                    ObjectId commitSha = repo.resolve(reference);
                    try (RevWalk revWalk = new RevWalk(repo);){
                        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitSha);
                        treeSha = revCommit.getTree();
                    }
                    instance.shaCache.put((Object)repo, (Object)reference, (Object)treeSha);
                }
                return treeSha;
            }
            catch (Exception e) {
                throw Errors.asRuntime((Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.gitRoots.values().stream().distinct().forEach(Repository::close);
    }
}

