/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableList;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;

class GradleProvisioner {
    private static final Logger logger = Logger.getLogger(GradleProvisioner.class.getName());

    private GradleProvisioner() {
    }

    static Provisioner newDedupingProvisioner(Project project) {
        return new DedupingProvisioner(project);
    }

    private static Provisioner forProject(Project project) {
        Objects.requireNonNull(project);
        return (withTransitives, mavenCoords) -> {
            try {
                Configuration config = (Configuration)project.getConfigurations().create("spotless" + new Request(withTransitives, mavenCoords).hashCode());
                mavenCoords.stream().map(arg_0 -> ((DependencyHandler)project.getDependencies()).create(arg_0)).forEach(arg_0 -> config.getDependencies().add(arg_0));
                config.setDescription(mavenCoords.toString());
                config.setTransitive(withTransitives);
                config.attributes(attr -> attr.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external"))));
                return config.resolve();
            }
            catch (Exception e) {
                String projName = project.getPath().substring(1).replace(':', '/');
                if (!projName.isEmpty()) {
                    projName = projName + "/";
                }
                logger.log(Level.SEVERE, "You need to add a repository containing the '" + mavenCoords + "' artifact in '" + projName + "build.gradle'.\nE.g.: 'repositories { mavenCentral() }'", e);
                throw e;
            }
        };
    }

    private static class Request {
        final boolean withTransitives;
        final ImmutableList<String> mavenCoords;

        public Request(boolean withTransitives, Collection<String> mavenCoords) {
            this.withTransitives = withTransitives;
            this.mavenCoords = ImmutableList.copyOf(mavenCoords);
        }

        public int hashCode() {
            return this.withTransitives ? this.mavenCoords.hashCode() : ~this.mavenCoords.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Request) {
                Request o = (Request)obj;
                return o.withTransitives == this.withTransitives && o.mavenCoords.equals(this.mavenCoords);
            }
            return false;
        }

        public String toString() {
            String coords = this.mavenCoords.toString();
            StringBuilder builder = new StringBuilder();
            builder.append(coords, 1, coords.length() - 1);
            if (this.withTransitives) {
                builder.append(" with transitives");
            } else {
                builder.append(" no transitives");
            }
            return builder.toString();
        }
    }

    static class DedupingProvisioner
    implements Provisioner {
        private final Project project;
        private final Map<Request, Set<File>> cache = new HashMap<Request, Set<File>>();

        DedupingProvisioner(Project project) {
            this.project = project;
        }

        public Set<File> provisionWithTransitives(boolean withTransitives, Collection<String> mavenCoordinates) {
            Request req = new Request(withTransitives, mavenCoordinates);
            Set<File> result = this.cache.get(req);
            if (result != null) {
                return result;
            }
            result = this.cache.get(req);
            if (result != null) {
                return result;
            }
            result = GradleProvisioner.forProject(this.project).provisionWithTransitives(req.withTransitives, req.mavenCoords);
            this.cache.put(req, result);
            return result;
        }
    }
}

