/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.Antlr4Extension;
import com.diffplug.gradle.spotless.CppExtension;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.FreshMarkExtension;
import com.diffplug.gradle.spotless.GroovyExtension;
import com.diffplug.gradle.spotless.GroovyGradleExtension;
import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.gradle.spotless.JsonExtension;
import com.diffplug.gradle.spotless.KotlinExtension;
import com.diffplug.gradle.spotless.KotlinGradleExtension;
import com.diffplug.gradle.spotless.PythonExtension;
import com.diffplug.gradle.spotless.RegisterDependenciesTask;
import com.diffplug.gradle.spotless.ScalaExtension;
import com.diffplug.gradle.spotless.SqlExtension;
import com.diffplug.gradle.spotless.TypescriptExtension;
import com.diffplug.spotless.LineEnding;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public abstract class SpotlessExtension {
    final Project project;
    protected static final String TASK_GROUP = "Verification";
    protected static final String CHECK_DESCRIPTION = "Checks that sourcecode satisfies formatting steps.";
    protected static final String APPLY_DESCRIPTION = "Applies code formatting steps to sourcecode in-place.";
    static final String EXTENSION = "spotless";
    static final String CHECK = "Check";
    static final String APPLY = "Apply";
    static final String DIAGNOSE = "Diagnose";
    LineEnding lineEndings = LineEnding.GIT_ATTRIBUTES;
    Charset encoding = StandardCharsets.UTF_8;
    @Nullable
    private String ratchetFrom;
    final Map<String, FormatExtension> formats = new LinkedHashMap<String, FormatExtension>();
    boolean enforceCheck = true;

    protected SpotlessExtension(Project project) {
        this.project = Objects.requireNonNull(project);
    }

    abstract RegisterDependenciesTask getRegisterDependenciesTask();

    public LineEnding getLineEndings() {
        return this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = Objects.requireNonNull(lineEndings);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String name) {
        Objects.requireNonNull(name);
        this.setEncoding(Charset.forName(name));
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void setRatchetFrom(String ratchetFrom) {
        this.ratchetFrom = ratchetFrom;
    }

    @Nullable
    public String getRatchetFrom() {
        return this.ratchetFrom;
    }

    public void ratchetFrom(String ratchetFrom) {
        this.setRatchetFrom(ratchetFrom);
    }

    public void java(Action<JavaExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("java", JavaExtension.class, closure);
    }

    public void scala(Action<ScalaExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("scala", ScalaExtension.class, closure);
    }

    public void kotlin(Action<KotlinExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("kotlin", KotlinExtension.class, closure);
    }

    public void kotlinGradle(Action<KotlinGradleExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("kotlinGradle", KotlinGradleExtension.class, closure);
    }

    public void freshmark(Action<FreshMarkExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("freshmark", FreshMarkExtension.class, closure);
    }

    public void groovy(Action<GroovyExtension> closure) {
        this.format("groovy", GroovyExtension.class, closure);
    }

    public void groovyGradle(Action<GroovyGradleExtension> closure) {
        this.format("groovyGradle", GroovyGradleExtension.class, closure);
    }

    public void sql(Action<SqlExtension> closure) {
        this.format("sql", SqlExtension.class, closure);
    }

    public void cpp(Action<CppExtension> closure) {
        this.format("cpp", CppExtension.class, closure);
    }

    public void typescript(Action<TypescriptExtension> closure) {
        this.format("typescript", TypescriptExtension.class, closure);
    }

    public void antlr4(Action<Antlr4Extension> closure) {
        this.format("antlr4", Antlr4Extension.class, closure);
    }

    public void python(Action<PythonExtension> closure) {
        this.format("python", PythonExtension.class, closure);
    }

    public void json(Action<JsonExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("json", JsonExtension.class, closure);
    }

    public void format(String name, Action<FormatExtension> closure) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(closure, "closure");
        this.format(name, FormatExtension.class, closure);
    }

    public boolean isEnforceCheck() {
        return this.enforceCheck;
    }

    public void setEnforceCheck(boolean enforceCheck) {
        this.enforceCheck = enforceCheck;
    }

    public <T extends FormatExtension> void format(String name, Class<T> clazz, Action<T> configure) {
        ((FormatExtension)this.maybeCreate((String)name, clazz)).lazyActions.add(configure);
    }

    protected final <T extends FormatExtension> T maybeCreate(String name, Class<T> clazz) {
        FormatExtension existing = this.formats.get(name);
        if (existing != null) {
            if (!clazz.isInstance(existing)) {
                throw new GradleException("Tried to add format named '" + name + "' of type " + clazz + " but one has already been created of type " + existing.getClass());
            }
            return (T)existing;
        }
        T formatExtension = this.instantiateFormatExtension(clazz);
        this.formats.put(name, (FormatExtension)formatExtension);
        this.createFormatTasks(name, (FormatExtension)formatExtension);
        return formatExtension;
    }

    <T extends FormatExtension> T instantiateFormatExtension(Class<T> clazz) {
        try {
            return (T)((FormatExtension)this.project.getObjects().newInstance(clazz, new Object[]{this}));
        }
        catch (Exception e) {
            throw new GradleException("Must have a constructor " + clazz.getSimpleName() + "(SpotlessExtension root), annotated with @javax.inject.Inject", (Throwable)e);
        }
    }

    protected abstract void createFormatTasks(String var1, FormatExtension var2);
}

