/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.archive;

import com.dipien.byebyejetifier.archive.ArchiveItem;
import com.dipien.byebyejetifier.archive.ArchiveItemVisitor;
import com.dipien.byebyejetifier.common.StringExtensionsKt;
import com.dipien.byebyejetifier.scanner.ScanResult;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0018R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/dipien/byebyejetifier/archive/ArchiveFile;", "Lcom/dipien/byebyejetifier/archive/ArchiveItem;", "relativePath", "Ljava/nio/file/Path;", "data", "", "(Ljava/nio/file/Path;[B)V", "<set-?>", "getData", "()[B", "", "fileName", "getFileName", "()Ljava/lang/String;", "getRelativePath", "()Ljava/nio/file/Path;", "accept", "", "visitor", "Lcom/dipien/byebyejetifier/archive/ArchiveItemVisitor;", "scanResults", "", "Lcom/dipien/byebyejetifier/scanner/ScanResult;", "isAndroidManifestFile", "", "isClassFile", "isLayoutResource", "Companion", "bye-bye-jetifier"})
public final class ArchiveFile
implements ArchiveItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Path relativePath;
    @NotNull
    private String fileName;
    @NotNull
    private byte[] data;
    @NotNull
    private static final String RES_LAYOUT_PATH = StringExtensionsKt.toFilePath("res/layout");

    public ArchiveFile(@NotNull Path relativePath, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.relativePath = relativePath;
        this.fileName = ((Object)relativePath.getFileName()).toString();
        this.data = data;
    }

    @Override
    @NotNull
    public Path getRelativePath() {
        return this.relativePath;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @Override
    public void accept(@NotNull ArchiveItemVisitor visitor, @NotNull List<ScanResult> scanResults) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        visitor.visit(this, scanResults);
    }

    public final boolean isLayoutResource() {
        return StringsKt.startsWith((String)((Object)this.getRelativePath()).toString(), (String)RES_LAYOUT_PATH, (boolean)true) && StringsKt.endsWith((String)this.getFileName(), (String)".xml", (boolean)true);
    }

    public final boolean isAndroidManifestFile() {
        return StringsKt.endsWith((String)this.getFileName(), (String)"AndroidManifest.xml", (boolean)true);
    }

    public final boolean isClassFile() {
        return StringsKt.endsWith((String)this.getFileName(), (String)".class", (boolean)true);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/dipien/byebyejetifier/archive/ArchiveFile$Companion;", "", "()V", "RES_LAYOUT_PATH", "", "getRES_LAYOUT_PATH", "()Ljava/lang/String;", "bye-bye-jetifier"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRES_LAYOUT_PATH() {
            return RES_LAYOUT_PATH;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

