/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.core.config;

import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.core.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dipien/byebyejetifier/core/config/ConfigParser;", "", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "loadFromFile", "Lcom/dipien/byebyejetifier/core/config/Config;", "configInputStream", "Ljava/io/InputStream;", "parseFromString", "inputText", "", "readText", "bye-bye-jetifier"})
public final class ConfigParser {
    @NotNull
    public static final ConfigParser INSTANCE = new ConfigParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private ConfigParser() {
    }

    @NotNull
    public final Config loadFromFile(@NotNull InputStream configInputStream) {
        Intrinsics.checkNotNullParameter((Object)configInputStream, (String)"configInputStream");
        Config config = this.parseFromString(this.readText(configInputStream));
        if (config == null) {
            throw new RuntimeException("Failed to parseFromString the config file");
        }
        return config;
    }

    private final Config parseFromString(String inputText) {
        LoggerHelper.INSTANCE.info("Parsing config file");
        return ((Config.JsonData)gson.fromJson(inputText, Config.JsonData.class)).toConfig();
    }

    private final String readText(InputStream configInputStream) {
        int bufferSize = 1024;
        char[] buffer = new char[bufferSize];
        StringBuilder output = new StringBuilder();
        Reader input = new InputStreamReader(configInputStream, StandardCharsets.UTF_8);
        int charsRead = 0;
        while (true) {
            int n = input.read(buffer, 0, buffer.length);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            charsRead = it;
            if (n <= 0) break;
            output.append(buffer, 0, charsRead);
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        return string;
    }
}

