/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.scanner;

import com.dipien.byebyejetifier.archive.Archive;
import com.dipien.byebyejetifier.archive.ArchiveFile;
import com.dipien.byebyejetifier.archive.ArchiveItem;
import com.dipien.byebyejetifier.archive.ArchiveItemVisitor;
import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.scanner.ScanResult;
import com.dipien.byebyejetifier.scanner.Scanner;
import com.dipien.byebyejetifier.scanner.ScannerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dipien/byebyejetifier/scanner/ScannerProcessor;", "Lcom/dipien/byebyejetifier/archive/ArchiveItemVisitor;", "context", "Lcom/dipien/byebyejetifier/scanner/ScannerContext;", "scannerList", "", "Lcom/dipien/byebyejetifier/scanner/Scanner;", "(Lcom/dipien/byebyejetifier/scanner/ScannerContext;Ljava/util/List;)V", "scanLibrary", "Lcom/dipien/byebyejetifier/scanner/ScanResult;", "archive", "Lcom/dipien/byebyejetifier/archive/Archive;", "visit", "", "scanResults", "", "archiveFile", "Lcom/dipien/byebyejetifier/archive/ArchiveFile;", "bye-bye-jetifier"})
public final class ScannerProcessor
implements ArchiveItemVisitor {
    @NotNull
    private final ScannerContext context;
    @NotNull
    private final List<Scanner> scannerList;

    public ScannerProcessor(@NotNull ScannerContext context, @NotNull List<? extends Scanner> scannerList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(scannerList, (String)"scannerList");
        this.context = context;
        this.scannerList = scannerList;
    }

    @NotNull
    public final List<ScanResult> scanLibrary(@NotNull Archive archive) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        boolean bl = false;
        List scanResults = new ArrayList();
        archive.accept(this, scanResults);
        return scanResults;
    }

    @Override
    public void visit(@NotNull Archive archive, @NotNull List<ScanResult> scanResults) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        Iterable $this$forEach$iv = archive.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArchiveItem it = (ArchiveItem)element$iv;
            boolean bl = false;
            it.accept(this, scanResults);
        }
    }

    @Override
    public void visit(@NotNull ArchiveFile archiveFile, @NotNull List<ScanResult> scanResults) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        if (this.context.isExcludedFileFromScanning(archiveFile)) {
            LoggerHelper.INSTANCE.debug(Intrinsics.stringPlus((String)"Excluded for scanning: ", (Object)archiveFile.getRelativePath()));
            return;
        }
        boolean fileLogged = false;
        Iterable $this$forEach$iv = this.scannerList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scanner it = (Scanner)element$iv;
            boolean bl = false;
            if (!it.canScan(archiveFile)) continue;
            if (!fileLogged) {
                fileLogged = true;
                LoggerHelper.INSTANCE.debug(Intrinsics.stringPlus((String)"File: ", (Object)archiveFile.getRelativePath()));
            }
            scanResults.addAll((Collection<ScanResult>)it.scan(archiveFile));
        }
    }
}

