/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.scanner.bytecode;

import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.core.type.JavaType;
import com.dipien.byebyejetifier.scanner.ScannerContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dipien/byebyejetifier/scanner/bytecode/CoreRemapper;", "", "context", "Lcom/dipien/byebyejetifier/scanner/ScannerContext;", "archiveFilePath", "", "(Lcom/dipien/byebyejetifier/scanner/ScannerContext;Ljava/lang/String;)V", "rewriteString", "value", "rewriteType", "Lcom/dipien/byebyejetifier/core/type/JavaType;", "type", "Companion", "bye-bye-jetifier"})
public final class CoreRemapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScannerContext context;
    @NotNull
    private final String archiveFilePath;
    @NotNull
    public static final String TAG = "CoreRemapper";
    @NotNull
    private static final Set<JavaType> AMBIGUOUS_STRINGS;

    public CoreRemapper(@NotNull ScannerContext context, @NotNull String archiveFilePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)archiveFilePath, (String)"archiveFilePath");
        this.context = context;
        this.archiveFilePath = archiveFilePath;
    }

    @NotNull
    public final JavaType rewriteType(@NotNull JavaType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result != null) {
            return result;
        }
        this.context.reportNoMappingFoundFailure(TAG, type);
        return type;
    }

    @NotNull
    public final String rewriteString(@NotNull String value) {
        JavaType subTypeResult;
        JavaType type;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean hasDotSeparators = StringsKt.contains$default((CharSequence)value, (CharSequence)".", (boolean)false, (int)2, null);
        boolean hasSlashSeparators = StringsKt.contains$default((CharSequence)value, (CharSequence)"/", (boolean)false, (int)2, null);
        if (hasDotSeparators && hasSlashSeparators) {
            return value;
        }
        JavaType javaType = type = hasDotSeparators ? JavaType.Companion.fromDotVersion(value) : new JavaType(value);
        if (!this.context.getConfig().isEligibleForRewrite(type)) {
            return value;
        }
        if (AMBIGUOUS_STRINGS.contains(type)) {
            LoggerHelper.warn$default(LoggerHelper.INSTANCE, "The file '" + this.archiveFilePath + "' contains a string literal with a package reference '" + value + "'. Libraries using reflection such as annotation processors need to be updated manually to add support for androidx. But if you are sure there is no need to transform this package reference you can ignore this message or exclude this file from scanning using the 'excludedFilesFromScanning' property.", null, 2, null);
            return value;
        }
        JavaType mappedString = this.context.getConfig().getStringsMap().mapType(type);
        if (mappedString != null) {
            LoggerHelper.INSTANCE.debug("Map string: '" + type + "' -> '" + mappedString + '\'');
            return hasDotSeparators ? mappedString.toDotNotation() : mappedString.getFullName();
        }
        JavaType mappedType = this.context.getConfig().getTypesMap().mapType(type);
        if (mappedType != null) {
            LoggerHelper.INSTANCE.debug("Map string: '" + type + "' -> '" + mappedType + '\'');
            return hasDotSeparators ? mappedType.toDotNotation() : mappedType.getFullName();
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)".", (boolean)false, (int)2, null) && (subTypeResult = this.context.getConfig().getTypesMap().mapType(type.getParentType())) != null) {
            String result = subTypeResult.toDotNotation() + '.' + StringsKt.substringAfterLast$default((String)value, (char)'.', null, (int)2, null);
            LoggerHelper.INSTANCE.debug("Map string: '" + value + "' -> '" + result + "' via type fallback");
            return result;
        }
        JavaType rewrittenType = this.context.getConfig().getRulesMap().rewriteType(type);
        if (rewrittenType != null) {
            LoggerHelper.INSTANCE.debug("Map string: '" + value + "' -> '" + rewrittenType + "' via fallback");
            return hasDotSeparators ? rewrittenType.toDotNotation() : rewrittenType.getFullName();
        }
        LoggerHelper.INSTANCE.debug("Found string '" + value + "' but failed to rewrite");
        return value;
    }

    static {
        Object[] objectArray = new JavaType[]{JavaType.Companion.fromDotVersion("android.support.v4"), JavaType.Companion.fromDotVersion("android.support.v4.content"), JavaType.Companion.fromDotVersion("android.support.v4.widget"), JavaType.Companion.fromDotVersion("android.support.v4.view"), JavaType.Companion.fromDotVersion("android.support.v4.media"), JavaType.Companion.fromDotVersion("android.support.v13"), JavaType.Companion.fromDotVersion("android.support.v13.view"), JavaType.Companion.fromDotVersion("android.support.v13.app"), JavaType.Companion.fromDotVersion("android.support.design.widget")};
        AMBIGUOUS_STRINGS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/dipien/byebyejetifier/scanner/bytecode/CoreRemapper$Companion;", "", "()V", "AMBIGUOUS_STRINGS", "", "Lcom/dipien/byebyejetifier/core/type/JavaType;", "getAMBIGUOUS_STRINGS", "()Ljava/util/Set;", "TAG", "", "bye-bye-jetifier"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<JavaType> getAMBIGUOUS_STRINGS() {
            return AMBIGUOUS_STRINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

