/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.scanner.resource;

import com.dipien.byebyejetifier.archive.ArchiveFile;
import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.core.type.JavaType;
import com.dipien.byebyejetifier.core.type.PackageName;
import com.dipien.byebyejetifier.scanner.ScanResult;
import com.dipien.byebyejetifier.scanner.Scanner;
import com.dipien.byebyejetifier.scanner.ScannerContext;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u0015\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/dipien/byebyejetifier/scanner/resource/XmlResourceScanner;", "Lcom/dipien/byebyejetifier/scanner/Scanner;", "context", "Lcom/dipien/byebyejetifier/scanner/ScannerContext;", "(Lcom/dipien/byebyejetifier/scanner/ScannerContext;)V", "patterns", "", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "canScan", "", "archiveFile", "Lcom/dipien/byebyejetifier/archive/ArchiveFile;", "getCharset", "Ljava/nio/charset/Charset;", "file", "isPackage", "token", "", "replaceWithPatterns", "Lcom/dipien/byebyejetifier/scanner/ScanResult;", "dataStr", "filePath", "Ljava/nio/file/Path;", "rewritePackage", "packageName", "rewriteType", "typeName", "scan", "Companion", "bye-bye-jetifier"})
public final class XmlResourceScanner
implements Scanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScannerContext context;
    @NotNull
    private final List<Pattern> patterns;
    @NotNull
    public static final String TAG = "XmlResourceScanner";
    public static final int PATTERN_TYPE_GROUP = 1;
    @NotNull
    private static final Regex JAVA_TOKEN_MATCHER;

    public XmlResourceScanner(@NotNull ScannerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object[] objectArray = new Pattern[]{Pattern.compile("</?([a-zA-Z0-9.]+)"), Pattern.compile("[a-zA-Z0-9:]+=\"([^\"]+)\""), Pattern.compile(">\\s*([a-zA-Z0-9.$_]+)<"), Pattern.compile("\\{@link\\s*([a-zA-Z0-9.$_]+)(#[^}]*)?}")};
        this.patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<ScanResult> scan(@NotNull ArchiveFile archiveFile) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Charset charset = this.getCharset(archiveFile);
        byte[] byArray = archiveFile.getData();
        boolean bl = false;
        boolean bl2 = false;
        String dataStr = new String(byArray, charset);
        return this.replaceWithPatterns(dataStr, this.patterns, archiveFile.getRelativePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Charset getCharset(ArchiveFile file) {
        try {
            Object object = file.getData();
            boolean bl = false;
            object = new ByteArrayInputStream((byte[])object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                boolean bl3 = false;
                XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(it);
                String string = xmlReader.getEncoding();
                if (string == null) {
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    return charset2;
                }
                Charset result = Charset.forName(xmlReader.getEncoding());
                if (result == null) {
                    LoggerHelper.error$default(LoggerHelper.INSTANCE, Intrinsics.stringPlus((String)"Failed to find charset for encoding ", (Object)xmlReader.getEncoding()), null, 2, null);
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset3 = charset;
                    return charset3;
                }
                Charset charset = result;
                return charset;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (XMLStreamException e) {
            LoggerHelper.warn$default(LoggerHelper.INSTANCE, "Received malformed sequence exception when trying to detect the encoding for " + file.getFileName() + ". Defaulting to UTF-8.", null, 2, null);
            if (LoggerHelper.INSTANCE.getVerbose()) {
                StringWriter tracePrinter = new StringWriter();
                e.printStackTrace(new PrintWriter(tracePrinter));
                String string = tracePrinter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tracePrinter.toString()");
                LoggerHelper.warn$default(LoggerHelper.INSTANCE, string, null, 2, null);
            }
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            return charset;
        }
    }

    private final List<ScanResult> replaceWithPatterns(String dataStr, List<Pattern> patterns, Path filePath) {
        boolean bl = false;
        Set result = new LinkedHashSet();
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(dataStr);
            while (matcher.find()) {
                String toReplace = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)toReplace, (String)"toReplace");
                CharSequence charSequence = toReplace;
                Regex regex = JAVA_TOKEN_MATCHER;
                boolean bl2 = false;
                String replacement = regex.matches(charSequence) ? (this.isPackage(toReplace) ? this.rewritePackage(toReplace, filePath) : this.rewriteType(toReplace)) : toReplace;
                if (Intrinsics.areEqual((Object)replacement, (Object)toReplace)) continue;
                result.add(new ScanResult(((Object)filePath).toString(), toReplace));
            }
        }
        return CollectionsKt.toList((Iterable)result);
    }

    private final boolean isPackage(String token) {
        boolean bl;
        block1: {
            CharSequence $this$any$iv = token;
            boolean $i$f$any = false;
            CharSequence charSequence = $this$any$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                char c = it;
                boolean bl3 = false;
                if (!Character.isUpperCase(c)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    private final String rewriteType(String typeName) {
        if (StringsKt.contains$default((CharSequence)typeName, (CharSequence)" ", (boolean)false, (int)2, null)) {
            return typeName;
        }
        JavaType type = JavaType.Companion.fromDotVersion(typeName);
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result != null) {
            return result.toDotNotation();
        }
        this.context.reportNoMappingFoundFailure(TAG, type);
        return typeName;
    }

    private final String rewritePackage(String packageName, Path filePath) {
        if (!StringsKt.contains$default((CharSequence)packageName, (char)'.', (boolean)false, (int)2, null)) {
            return packageName;
        }
        PackageName pckg = PackageName.Companion.fromDotVersion(packageName);
        PackageName result = this.context.getConfig().getPackageMap().getPackageFor(pckg);
        if (result != null) {
            LoggerHelper.INSTANCE.debug("Map package: " + packageName + " -> " + result);
            return result.toDotNotation();
        }
        if (this.context.getConfig().isEligibleForRewrite(pckg)) {
            LoggerHelper.error$default(LoggerHelper.INSTANCE, "No mapping for package '" + packageName + "' in '" + filePath + "', keeping identity", null, 2, null);
        }
        return packageName;
    }

    @Override
    public boolean canScan(@NotNull ArchiveFile archiveFile) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        return archiveFile.isLayoutResource() || archiveFile.isAndroidManifestFile();
    }

    static {
        String string = "^[a-zA-Z0-9.$_]+$";
        boolean bl = false;
        JAVA_TOKEN_MATCHER = new Regex(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/dipien/byebyejetifier/scanner/resource/XmlResourceScanner$Companion;", "", "()V", "JAVA_TOKEN_MATCHER", "Lkotlin/text/Regex;", "getJAVA_TOKEN_MATCHER", "()Lkotlin/text/Regex;", "PATTERN_TYPE_GROUP", "", "TAG", "", "bye-bye-jetifier"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getJAVA_TOKEN_MATCHER() {
            return JAVA_TOKEN_MATCHER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

