/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.task;

import com.dipien.byebyejetifier.ProjectAnalyzer;
import com.dipien.byebyejetifier.ProjectAnalyzerResult;
import com.dipien.byebyejetifier.common.AbstractTask;
import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.core.config.Config;
import com.dipien.byebyejetifier.core.config.ConfigParser;
import com.dipien.byebyejetifier.scanner.Scanner;
import com.dipien.byebyejetifier.scanner.ScannerContext;
import com.dipien.byebyejetifier.scanner.ScannerProcessor;
import com.dipien.byebyejetifier.scanner.bytecode.BytecodeScanner;
import com.dipien.byebyejetifier.scanner.resource.XmlResourceScanner;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0014R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/dipien/byebyejetifier/task/CanISayByeByeJetifierTask;", "Lcom/dipien/byebyejetifier/common/AbstractTask;", "()V", "excludeSupportAnnotations", "", "getExcludeSupportAnnotations", "()Z", "setExcludeSupportAnnotations", "(Z)V", "excludedConfigurations", "", "", "getExcludedConfigurations", "()Ljava/util/List;", "setExcludedConfigurations", "(Ljava/util/List;)V", "excludedFilesFromScanning", "getExcludedFilesFromScanning", "setExcludedFilesFromScanning", "excludedProjectsFromScanning", "getExcludedProjectsFromScanning", "setExcludedProjectsFromScanning", "legacyGroupIdPrefixes", "getLegacyGroupIdPrefixes", "setLegacyGroupIdPrefixes", "scannerProcessor", "Lcom/dipien/byebyejetifier/scanner/ScannerProcessor;", "getScannerProcessor", "()Lcom/dipien/byebyejetifier/scanner/ScannerProcessor;", "scannerProcessor$delegate", "Lkotlin/Lazy;", "onExecute", "", "Companion", "bye-bye-jetifier"})
public class CanISayByeByeJetifierTask
extends AbstractTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> legacyGroupIdPrefixes = CollectionsKt.emptyList();
    @NotNull
    private List<String> excludedConfigurations = CollectionsKt.emptyList();
    @NotNull
    private List<String> excludedFilesFromScanning = CollectionsKt.emptyList();
    @NotNull
    private List<String> excludedProjectsFromScanning = CollectionsKt.emptyList();
    private boolean excludeSupportAnnotations = true;
    @NotNull
    private final Lazy scannerProcessor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScannerProcessor>(this){
        final /* synthetic */ CanISayByeByeJetifierTask this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final ScannerProcessor invoke() {
            InputStream inputStream = ((Object)((Object)this.this$0)).getClass().getClassLoader().getResourceAsStream("default.config");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream inputStream2 = inputStream;
            Config config = ConfigParser.INSTANCE.loadFromFile(inputStream2);
            ScannerContext scannerContext = new ScannerContext(config, this.this$0.getExcludedFilesFromScanning());
            Object[] objectArray = new Scanner[]{new BytecodeScanner(scannerContext), new XmlResourceScanner(scannerContext)};
            List scannerList = CollectionsKt.listOf((Object[])objectArray);
            return new ScannerProcessor(scannerContext, scannerList);
        }
    }));
    @NotNull
    public static final String TASK_NAME = "canISayByeByeJetifier";
    @NotNull
    public static final String ENABLE_JETIFIER_PROPERTY = "android.enableJetifier";
    @NotNull
    private static final String DEFAULT_CONFIG = "default.config";

    public CanISayByeByeJetifierTask() {
        this.setGroup("Verification");
        this.setDescription("Verifies if you can keep Android Jetifier disabled");
    }

    @Input
    @Optional
    @NotNull
    public final List<String> getLegacyGroupIdPrefixes() {
        return this.legacyGroupIdPrefixes;
    }

    public final void setLegacyGroupIdPrefixes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.legacyGroupIdPrefixes = list;
    }

    @Input
    @Optional
    @NotNull
    public final List<String> getExcludedConfigurations() {
        return this.excludedConfigurations;
    }

    public final void setExcludedConfigurations(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.excludedConfigurations = list;
    }

    @Input
    @Optional
    @NotNull
    public final List<String> getExcludedFilesFromScanning() {
        return this.excludedFilesFromScanning;
    }

    public final void setExcludedFilesFromScanning(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.excludedFilesFromScanning = list;
    }

    @Input
    @Optional
    @NotNull
    public final List<String> getExcludedProjectsFromScanning() {
        return this.excludedProjectsFromScanning;
    }

    public final void setExcludedProjectsFromScanning(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.excludedProjectsFromScanning = list;
    }

    @Input
    public final boolean getExcludeSupportAnnotations() {
        return this.excludeSupportAnnotations;
    }

    public final void setExcludeSupportAnnotations(boolean bl) {
        this.excludeSupportAnnotations = bl;
    }

    private final ScannerProcessor getScannerProcessor() {
        Lazy lazy = this.scannerProcessor$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (ScannerProcessor)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onExecute() {
        void $this$filterTo$iv$iv;
        if (this.getProject().hasProperty(ENABLE_JETIFIER_PROPERTY) && Intrinsics.areEqual((Object)this.getProject().property(ENABLE_JETIFIER_PROPERTY), (Object)"true")) {
            throw new GradleException("This task needs to be run with Jetifier disabled: ./gradlew canISayByeByeJetifier -Pandroid.enableJetifier=false");
        }
        LoggerHelper.log$default(LoggerHelper.INSTANCE, Intrinsics.stringPlus((String)"excludedConfigurations: ", this.excludedConfigurations), null, 2, null);
        LoggerHelper.log$default(LoggerHelper.INSTANCE, Intrinsics.stringPlus((String)"excludedFilesFromScanning: ", this.excludedFilesFromScanning), null, 2, null);
        LoggerHelper.log$default(LoggerHelper.INSTANCE, Intrinsics.stringPlus((String)"excludedProjectsFromScanning: ", this.excludedProjectsFromScanning), null, 2, null);
        LoggerHelper.log$default(LoggerHelper.INSTANCE, Intrinsics.stringPlus((String)"excludeSupportAnnotations: ", (Object)this.excludeSupportAnnotations), null, 2, null);
        ProjectAnalyzerResult projectAnalyzerResult = new ProjectAnalyzerResult();
        Set set = this.getProject().getAllprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.allprojects");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            if (!(!this.getExcludedProjectsFromScanning().contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            new ProjectAnalyzer(it, this.getExcludedConfigurations(), this.getLegacyGroupIdPrefixes(), this.getScannerProcessor(), this.getExcludeSupportAnnotations()).analyze(projectAnalyzerResult);
        }
        if (projectAnalyzerResult.getThereAreSupportLibraryDependencies() || projectAnalyzerResult.getIncludeSupportLibrary()) {
            throw new RuntimeException("You can not say Bye Bye Jetifier");
        }
        LoggerHelper.INSTANCE.lifeCycle("");
        LoggerHelper.INSTANCE.lifeCycle("=====================================================================================");
        LoggerHelper.INSTANCE.lifeCycle("* No dependencies with legacy android support usages! You can say Bye Bye Jetifier. *");
        LoggerHelper.INSTANCE.lifeCycle("=====================================================================================");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/dipien/byebyejetifier/task/CanISayByeByeJetifierTask$Companion;", "", "()V", "DEFAULT_CONFIG", "", "ENABLE_JETIFIER_PROPERTY", "TASK_NAME", "bye-bye-jetifier"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

