/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.concurrent;

import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import com.facebook.presto.jdbc.internal.guava.collect.Iterables;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.FutureCallback;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.Futures;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ListenableFuture;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class MoreFutures {
    private MoreFutures() {
    }

    public static <V> CompletableFuture<V> unmodifiableFuture(CompletableFuture<V> future) {
        Objects.requireNonNull(future, "future is null");
        UnmodifiableCompletableFuture unmodifiableFuture = new UnmodifiableCompletableFuture();
        future.whenComplete((value, exception) -> {
            if (exception != null) {
                unmodifiableFuture.internalCompleteExceptionally((Throwable)exception);
            } else {
                unmodifiableFuture.internalComplete(value);
            }
        });
        return unmodifiableFuture;
    }

    public static <V> CompletableFuture<V> failedFuture(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <V> V getFutureValue(Future<V> future) {
        return MoreFutures.getFutureValue(future, RuntimeException.class);
    }

    public static <V, E extends Exception> V getFutureValue(Future<V> future, Class<E> exceptionType) throws E {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(exceptionType, "exceptionType is null");
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.propagateIfInstanceOf(cause, exceptionType);
            throw Throwables.propagate(cause);
        }
    }

    public static <V> Optional<V> tryGetFutureValue(Future<V> future, int timeout, TimeUnit timeUnit) {
        return MoreFutures.tryGetFutureValue(future, timeout, timeUnit, RuntimeException.class);
    }

    public static <V, E extends Exception> Optional<V> tryGetFutureValue(Future<V> future, int timeout, TimeUnit timeUnit, Class<E> exceptionType) throws E {
        Objects.requireNonNull(future, "future is null");
        Preconditions.checkArgument(timeout >= 0, "timeout is negative");
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        Objects.requireNonNull(exceptionType, "exceptionType is null");
        try {
            return Optional.ofNullable(future.get(timeout, timeUnit));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.propagateIfInstanceOf(cause, exceptionType);
            throw Throwables.propagate(cause);
        }
        catch (TimeoutException timeoutException) {
            return Optional.empty();
        }
    }

    public static <V> CompletableFuture<V> firstCompletedFuture(Iterable<? extends CompletionStage<? extends V>> futures) {
        Objects.requireNonNull(futures, "futures is null");
        Preconditions.checkArgument(!Iterables.isEmpty(futures), "futures is empty");
        CompletableFuture future = new CompletableFuture();
        for (CompletionStage<V> stage : futures) {
            stage.whenComplete((value, exception) -> {
                if (exception != null) {
                    future.completeExceptionally((Throwable)exception);
                } else {
                    future.complete(value);
                }
            });
        }
        return future;
    }

    public static <V> CompletableFuture<V> toCompletableFuture(ListenableFuture<V> listenableFuture) {
        Objects.requireNonNull(listenableFuture, "listenableFuture is null");
        final CompletableFuture future = new CompletableFuture();
        future.exceptionally(throwable -> {
            if (throwable instanceof CancellationException) {
                listenableFuture.cancel(true);
            }
            return null;
        });
        Futures.addCallback(listenableFuture, new FutureCallback<V>(){

            @Override
            public void onSuccess(V result) {
                future.complete(result);
            }

            @Override
            public void onFailure(Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public static <V> ListenableFuture<V> toListenableFuture(final CompletableFuture<V> completableFuture) {
        Objects.requireNonNull(completableFuture, "completableFuture is null");
        SettableFuture future = SettableFuture.create();
        Futures.addCallback(future, new FutureCallback<V>(){

            @Override
            public void onSuccess(V result) {
            }

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof CancellationException) {
                    completableFuture.cancel(true);
                }
            }
        });
        completableFuture.whenComplete((value, exception) -> {
            if (exception != null) {
                future.setException((Throwable)exception);
            } else {
                future.set(value);
            }
        });
        return future;
    }

    private static class UnmodifiableCompletableFuture<V>
    extends CompletableFuture<V> {
        private UnmodifiableCompletableFuture() {
        }

        void internalComplete(V value) {
            super.complete(value);
        }

        void internalCompleteExceptionally(Throwable ex) {
            super.completeExceptionally(ex);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean complete(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeException(Throwable ex) {
            throw new UnsupportedOperationException();
        }
    }
}

