/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.configuration.Config;
import com.facebook.presto.jdbc.internal.airlift.configuration.LegacyConfig;
import com.facebook.presto.jdbc.internal.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.airlift.units.MinDuration;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Beta
public class HttpClientConfig {
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private Duration connectTimeout = new Duration(1.0, TimeUnit.SECONDS);
    private Duration requestTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private Duration idleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration keepAliveInterval;
    private int maxConnections = 200;
    private int maxConnectionsPerServer = 20;
    private int maxRequestsQueuedPerDestination = 1024;
    private DataSize maxContentLength = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private HostAndPort socksProxy;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");

    @NotNull
    @MinDuration(value="0ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="http-client.connect-timeout")
    public HttpClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="http-client.request-timeout")
    public HttpClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="http-client.idle-timeout")
    @LegacyConfig(value={"http-client.read-timeout"})
    public HttpClientConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @Deprecated
    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    @Deprecated
    @Config(value="http-client.keep-alive-interval")
    public HttpClientConfig setKeepAliveInterval(Duration keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Config(value="http-client.max-connections")
    public HttpClientConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @Min(value=1L)
    public int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="http-client.max-connections-per-server")
    public HttpClientConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    @Min(value=1L)
    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    @Config(value="http-client.max-requests-queued-per-destination")
    public HttpClientConfig setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
        return this;
    }

    @NotNull
    public DataSize getMaxContentLength() {
        return this.maxContentLength;
    }

    @Config(value="http-client.max-content-length")
    public HttpClientConfig setMaxContentLength(DataSize maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="http-client.socks-proxy")
    public HttpClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="http-client.key-store-path")
    public HttpClientConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="http-client.key-store-password")
    public HttpClientConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }
}

