/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.util;

import com.facebook.presto.jdbc.internal.jetty.client.api.Authentication;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentResponse;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.util.Attributes;
import com.facebook.presto.jdbc.internal.jetty.util.B64Code;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class BasicAuthentication
implements Authentication {
    private final URI uri;
    private final String realm;
    private final String user;
    private final String password;

    public BasicAuthentication(URI uri, String realm, String user, String password) {
        this.uri = uri;
        this.realm = realm;
        this.user = user;
        this.password = password;
    }

    @Override
    public boolean matches(String type, URI uri, String realm) {
        if (!"basic".equalsIgnoreCase(type)) {
            return false;
        }
        if (!uri.toString().startsWith(this.uri.toString())) {
            return false;
        }
        return this.realm.equals(realm);
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        String value = "Basic " + B64Code.encode(this.user + ":" + this.password, StandardCharsets.ISO_8859_1);
        return new BasicResult(headerInfo.getHeader(), this.uri, value);
    }

    private static class BasicResult
    implements Authentication.Result {
        private final HttpHeader header;
        private final URI uri;
        private final String value;

        public BasicResult(HttpHeader header, URI uri, String value) {
            this.header = header;
            this.uri = uri;
            this.value = value;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void apply(Request request) {
            request.header(this.header, this.value);
        }

        public String toString() {
            return String.format("Basic authentication result for %s", this.uri);
        }
    }
}

