/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.util;

import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class IteratingCallback
implements Callback {
    private final AtomicReference<State> _state;
    private boolean _iterate;

    protected IteratingCallback() {
        this._state = new AtomicReference<State>(State.IDLE);
    }

    protected IteratingCallback(boolean needReset) {
        this._state = new AtomicReference<State>(needReset ? State.SUCCEEDED : State.IDLE);
    }

    protected abstract Action process() throws Exception;

    @Deprecated
    protected void completed() {
    }

    protected void onCompleteSuccess() {
        this.completed();
    }

    protected void onCompleteFailure(Throwable x) {
    }

    public void iterate() {
        block7: while (true) {
            State state = this._state.get();
            switch (state) {
                case PENDING: 
                case CALLED: {
                    break block7;
                }
                case IDLE: {
                    if (!this._state.compareAndSet(state, State.PROCESSING)) continue block7;
                    this.processing();
                    break block7;
                }
                case PROCESSING: {
                    if (!this._state.compareAndSet(state, State.LOCKED)) continue block7;
                    this._iterate = true;
                    this._state.set(State.PROCESSING);
                    break block7;
                }
                case LOCKED: {
                    Thread.yield();
                    continue block7;
                }
                case FAILED: 
                case SUCCEEDED: {
                    break block7;
                }
                default: {
                    throw new IllegalStateException("state=" + (Object)((Object)state));
                }
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processing() {
        block16: while (true) {
            try {
                action = this.process();
            }
            catch (Throwable x) {
                this.failed(x);
                break;
            }
            block17: while (true) {
                state = this._state.get();
                switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[state.ordinal()]) {
                    case 4: {
                        switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$Action[action.ordinal()]) {
                            case 1: {
                                if (!this._state.compareAndSet(state, State.LOCKED)) continue block17;
                                if (this._iterate) {
                                    this._iterate = false;
                                    this._state.set(State.PROCESSING);
                                    continue block16;
                                }
                                this._state.set(State.IDLE);
                                break block16;
                            }
                            case 2: {
                                if (this._state.compareAndSet(state, State.PENDING)) break block16;
                                continue block17;
                            }
                            case 3: {
                                if (!this._state.compareAndSet(state, State.LOCKED)) continue block17;
                                this._iterate = false;
                                this._state.set(State.SUCCEEDED);
                                this.onCompleteSuccess();
                                break block16;
                            }
                            default: {
                                throw new IllegalStateException("state=" + (Object)state + " action=" + (Object)action);
                            }
                        }
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$Action[action.ordinal()]) {
                            case 2: {
                                if (!this._state.compareAndSet(state, State.PROCESSING)) ** break;
                                continue block16;
                                continue block17;
                            }
                        }
                        throw new IllegalStateException("state=" + (Object)state + " action=" + (Object)action);
                    }
                    case 5: {
                        Thread.yield();
                        continue block17;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        break block16;
                    }
                    default: {
                        throw new IllegalStateException("state=" + (Object)state + " action=" + (Object)action);
                    }
                }
                break;
            }
            break;
        }
    }

    @Override
    public void succeeded() {
        block6: while (true) {
            State state = this._state.get();
            switch (state) {
                case PROCESSING: {
                    if (this._state.compareAndSet(state, State.CALLED)) break block6;
                    continue block6;
                }
                case PENDING: {
                    if (!this._state.compareAndSet(state, State.PROCESSING)) continue block6;
                    this.processing();
                    break block6;
                }
                case FAILED: 
                case CLOSED: {
                    break block6;
                }
                case LOCKED: {
                    Thread.yield();
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("state=" + (Object)((Object)state));
                }
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void failed(Throwable x) {
        block5: while (true) {
            state = this._state.get();
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[state.ordinal()]) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break block5;
                }
                case 5: {
                    Thread.yield();
                    continue block5;
                }
                case 1: 
                case 4: {
                    if (this._state.compareAndSet(state, State.FAILED)) ** break;
                    continue block5;
                    this.onCompleteFailure(x);
                    break block5;
                }
                default: {
                    throw new IllegalStateException("state=" + (Object)state);
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void close() {
        block5: while (true) {
            State state = this._state.get();
            switch (state) {
                case IDLE: 
                case FAILED: 
                case SUCCEEDED: {
                    if (this._state.compareAndSet(state, State.CLOSED)) return;
                    continue block5;
                }
                case CLOSED: {
                    return;
                }
                case LOCKED: {
                    Thread.yield();
                    continue block5;
                }
            }
            if (this._state.compareAndSet(state, State.CLOSED)) break;
        }
        this.onCompleteFailure(new ClosedChannelException());
    }

    boolean isIdle() {
        return this._state.get() == State.IDLE;
    }

    public boolean isClosed() {
        return this._state.get() == State.CLOSED;
    }

    public boolean isFailed() {
        return this._state.get() == State.FAILED;
    }

    public boolean isSucceeded() {
        return this._state.get() == State.SUCCEEDED;
    }

    public boolean reset() {
        block6: while (true) {
            State state = this._state.get();
            switch (state) {
                case IDLE: {
                    return true;
                }
                case SUCCEEDED: {
                    if (!this._state.compareAndSet(state, State.LOCKED)) continue block6;
                    this._iterate = false;
                    this._state.set(State.IDLE);
                    return true;
                }
                case FAILED: {
                    if (!this._state.compareAndSet(state, State.LOCKED)) continue block6;
                    this._iterate = false;
                    this._state.set(State.IDLE);
                    return true;
                }
                case LOCKED: {
                    Thread.yield();
                    continue block6;
                }
            }
            break;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._state);
    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED;

    }

    private static enum State {
        IDLE,
        PROCESSING,
        PENDING,
        CALLED,
        SUCCEEDED,
        FAILED,
        CLOSED,
        LOCKED;

    }
}

