/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.type.TimeZoneKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ConnectorSession {
    private final String user;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final long startTime;
    private final Map<String, String> properties;

    @JsonCreator
    public ConnectorSession(@JsonProperty(value="user") String user, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="properties") Map<String, String> properties) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Session{");
        builder.append("user='").append(this.user).append('\'');
        builder.append(", timeZoneKey=").append(this.timeZoneKey);
        builder.append(", locale=").append(this.locale);
        builder.append(", startTime=").append(this.startTime);
        builder.append(", properties=").append(this.properties);
        builder.append('}');
        return builder.toString();
    }
}

