/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.NotFoundException;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;

public class TableNotFoundException
extends NotFoundException {
    private final SchemaTableName tableName;

    public TableNotFoundException(SchemaTableName tableName) {
        this(tableName, String.format("Table '%s' not found", tableName));
    }

    public TableNotFoundException(SchemaTableName tableName, String message) {
        super(message);
        if (tableName == null) {
            throw new NullPointerException("tableName is null");
        }
        this.tableName = tableName;
    }

    public TableNotFoundException(SchemaTableName tableName, Throwable cause) {
        this(tableName, String.format("Table '%s' not found", tableName), cause);
    }

    public TableNotFoundException(SchemaTableName tableName, String message, Throwable cause) {
        super(message, cause);
        if (tableName == null) {
            throw new NullPointerException("tableName is null");
        }
        this.tableName = tableName;
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

