/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonIgnore;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.Marker;
import java.util.Objects;

public final class Range {
    private final Marker low;
    private final Marker high;

    @JsonCreator
    public Range(@JsonProperty(value="low") Marker low, @JsonProperty(value="high") Marker high) {
        Objects.requireNonNull(low, "value is null");
        Objects.requireNonNull(high, "value is null");
        if (!low.getType().equals(high.getType())) {
            throw new IllegalArgumentException(String.format("Marker types do not match: %s vs %s", low.getType(), high.getType()));
        }
        if (low.isUpperUnbounded()) {
            throw new IllegalArgumentException("low cannot be upper unbounded");
        }
        if (high.isLowerUnbounded()) {
            throw new IllegalArgumentException("high cannot be lower unbounded");
        }
        if (low.compareTo(high) > 0) {
            throw new IllegalArgumentException("low must be less than or equal to high");
        }
        this.low = low;
        this.high = high;
    }

    public static Range all(Class<?> type) {
        return new Range(Marker.lowerUnbounded(type), Marker.upperUnbounded(type));
    }

    public static Range greaterThan(Comparable<?> low) {
        return new Range(Marker.above(low), Marker.upperUnbounded(low.getClass()));
    }

    public static Range greaterThanOrEqual(Comparable<?> low) {
        return new Range(Marker.exactly(low), Marker.upperUnbounded(low.getClass()));
    }

    public static Range lessThan(Comparable<?> high) {
        return new Range(Marker.lowerUnbounded(high.getClass()), Marker.below(high));
    }

    public static Range lessThanOrEqual(Comparable<?> high) {
        return new Range(Marker.lowerUnbounded(high.getClass()), Marker.exactly(high));
    }

    public static Range equal(Comparable<?> value) {
        return new Range(Marker.exactly(value), Marker.exactly(value));
    }

    public static Range range(Comparable<?> low, boolean lowInclusive, Comparable<?> high, boolean highInclusive) {
        Marker lowMarker = lowInclusive ? Marker.exactly(low) : Marker.above(low);
        Marker highMarker = highInclusive ? Marker.exactly(high) : Marker.below(high);
        return new Range(lowMarker, highMarker);
    }

    @JsonIgnore
    public Class<?> getType() {
        return this.low.getType();
    }

    @JsonProperty
    public Marker getLow() {
        return this.low;
    }

    @JsonProperty
    public Marker getHigh() {
        return this.high;
    }

    @JsonIgnore
    public boolean isSingleValue() {
        return !this.low.isLowerUnbounded() && !this.high.isUpperUnbounded() && this.low.getBound() == Marker.Bound.EXACTLY && this.high.getBound() == Marker.Bound.EXACTLY && this.low.getValue().equals(this.high.getValue());
    }

    @JsonIgnore
    public Comparable<?> getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Range does not have just a single value");
        }
        return this.low.getValue();
    }

    @JsonIgnore
    public boolean isAll() {
        return this.low.isLowerUnbounded() && this.high.isUpperUnbounded();
    }

    public boolean includes(Marker marker) {
        Objects.requireNonNull(marker, "marker is null");
        this.checkTypeCompatibility(marker);
        return this.low.compareTo(marker) <= 0 && this.high.compareTo(marker) >= 0;
    }

    public boolean contains(Range other) {
        this.checkTypeCompatibility(other);
        return this.getLow().compareTo(other.getLow()) <= 0 && this.getHigh().compareTo(other.getHigh()) >= 0;
    }

    public Range span(Range other) {
        this.checkTypeCompatibility(other);
        Marker lowMarker = Marker.min(this.low, other.getLow());
        Marker highMarker = Marker.max(this.high, other.getHigh());
        return new Range(lowMarker, highMarker);
    }

    public boolean overlaps(Range other) {
        this.checkTypeCompatibility(other);
        return this.getLow().compareTo(other.getHigh()) <= 0 && other.getLow().compareTo(this.getHigh()) <= 0;
    }

    public Range intersect(Range other) {
        this.checkTypeCompatibility(other);
        if (!this.overlaps(other)) {
            throw new IllegalArgumentException("Cannot intersect non-overlapping ranges");
        }
        Marker lowMarker = Marker.max(this.low, other.getLow());
        Marker highMarker = Marker.min(this.high, other.getHigh());
        return new Range(lowMarker, highMarker);
    }

    private void checkTypeCompatibility(Range range) {
        if (!this.getType().equals(range.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Range types: %s vs %s", this.getType(), range.getType()));
        }
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType())) {
            throw new IllegalArgumentException(String.format("Marker of %s does not match Range of %s", marker.getType(), this.getType()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isSingleValue()) {
            sb.append('[').append(this.low.getValue()).append(']');
        } else {
            sb.append(this.low.getBound() == Marker.Bound.EXACTLY ? (char)'[' : '(');
            sb.append(this.low.isLowerUnbounded() ? "<min>" : this.low.getValue());
            sb.append(", ");
            sb.append(this.high.isUpperUnbounded() ? "<max>" : this.high.getValue());
            sb.append(this.high.getBound() == Marker.Bound.EXACTLY ? (char)']' : ')');
        }
        return sb.toString();
    }
}

