/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractType
implements Type {
    private final TypeSignature signature;
    private final Class<?> javaType;

    protected AbstractType(TypeSignature signature, Class<?> javaType) {
        this.signature = signature;
        this.javaType = javaType;
    }

    @Override
    public final TypeSignature getTypeSignature() {
        return this.signature;
    }

    @Override
    public String getDisplayName() {
        return this.signature.toString();
    }

    @Override
    public final Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public int hash(Block block, int position) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not ordered");
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return this.getTypeSignature().toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getTypeSignature().equals(((Type)o).getTypeSignature());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }
}

